/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template.help;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SemaphoreHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SemaphoreHandler.class);
    private static final long INDEX_PROCESS_TIMEOUT = 100L;
    private final Semaphore semaphore;

    public SemaphoreHandler(int threadNum) {
        this.semaphore = new Semaphore(threadNum);
    }

    public void acquire() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Semaphore acquire error.", (Throwable)e);
        }
    }

    public boolean waitFor(int permits) {
        boolean acquireResult = true;
        try {
            if (!this.semaphore.tryAcquire(permits, 100L, TimeUnit.MINUTES)) {
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "ThreadPool exist thread of Not Closed. Index create not property.");
                acquireResult = false;
            }
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Semaphore try acquiring... Thread interrupt.", (Throwable)e);
            acquireResult = false;
        }
        this.semaphore.release(permits);
        return acquireResult;
    }

    public void release() {
        this.semaphore.release();
    }
}

