/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class IndexFileUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexFileUtils.class);

    private IndexFileUtils() {
    }

    public static void write(String path, String content, boolean append) {
        File file = FileUtils.getFile((String[])new String[]{path});
        File parentDir = file.getParentFile();
        if (parentDir == null || !parentDir.exists() && !parentDir.mkdirs()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create dir fail.");
            return;
        }
        try (FileOutputStream outputStream = FileUtils.openOutputStream((File)file, (boolean)append);
             OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(streamWriter);){
            bufferedWriter.write(content);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Write file content error.", (Throwable)e);
        }
    }
}

