/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.util;

import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.jsoup.nodes.Element;

public class StrategyCommonUtils {
    public static void addFeatureToIndex(String fieldName, Element element, Collection<Field> textFields) {
        String value = StringUtils.trim((String)StringUtils.toRootLowerCase((String)IndexUtils.outBlankLine(element.attr("content"))));
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Set<String> featureSet = StrategyCommonUtils.splitFeatureValue(value);
        if (CollectionUtils.isEmpty(featureSet)) {
            return;
        }
        String features = String.join((CharSequence)" ", featureSet);
        textFields.add(IndexUtils.getField(fieldName, features, Field.Store.YES, TextField.class.getSimpleName()));
    }

    private static Set<String> splitFeatureValue(String featureValue) {
        Optional<String[]> strings = Optional.ofNullable(featureValue).map(value -> value.split(","));
        if (!strings.isPresent()) {
            return Collections.emptySet();
        }
        return Arrays.stream((Object[])strings.get()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(name -> StringUtils.trim((String)IndexUtils.outBlankLine(name))).collect(Collectors.toSet());
    }
}

