/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.analyzer;

import com.hankcs.hanlp.dictionary.other.CharType;
import com.huawei.support.icscbb.commonsearch.lucene.analyzer.HanlpChineseTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;

public final class HanlpChineseAnalyzer
extends Analyzer {
    private final Set<String> stopWords;
    private final boolean isEnableIndexMode;

    public HanlpChineseAnalyzer() {
        this(true, false);
    }

    public HanlpChineseAnalyzer(boolean isUseDefaultStopWords) {
        this(isUseDefaultStopWords, false);
    }

    public HanlpChineseAnalyzer(boolean isUseDefaultStopWords, boolean isEnableIndexMode) {
        this.stopWords = isUseDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : Collections.emptySet();
        this.isEnableIndexMode = isEnableIndexMode;
    }

    public HanlpChineseAnalyzer(Set<String> stopWords) {
        this(stopWords, false);
    }

    public HanlpChineseAnalyzer(Set<String> stopWords, boolean isEnableIndexMode) {
        this.stopWords = stopWords == null ? Collections.emptySet() : stopWords;
        this.isEnableIndexMode = isEnableIndexMode;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        HanlpChineseTokenizer tokenizer = new HanlpChineseTokenizer(this.isEnableIndexMode);
        EnglishPossessiveFilter result = new EnglishPossessiveFilter((TokenStream)tokenizer);
        result = new LowerCaseFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter((TokenStream)result, CharArraySet.copy(this.stopWords));
        }
        result = new PorterStemFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    static {
        CharType.type[45] = 6;
        CharType.type[95] = 6;
        CharType.type[60] = 6;
        CharType.type[62] = 6;
        CharType.type[126] = 6;
        CharType.type[35] = 6;
        CharType.type[36] = 6;
        CharType.type[64] = 6;
        CharType.type[38] = 6;
        CharType.type[39] = 6;
        CharType.type[37] = 6;
        CharType.type[94] = 6;
        CharType.type[96] = 6;
    }

    private static class DefaultSetHolder {
        static final Set<String> DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();

        private DefaultSetHolder() {
        }

        static Set<String> loadDefaultStopWordSet() {
            HashSet<String> defaultStopSet = new HashSet<String>(Arrays.asList(",", ".", "`", "-", "_", "=", "?", "'", "|", "\"", "(", ")", "{", "}", "[", "]", "<", ">", "*", "#", "&", "^", "$", "@", "!", "~", ":", ";", "+", "/", "\\", "\u300a", "\u300b", "\u2014", "\uff0d", "\uff0c", "\u3002", "\u3001", "\uff1a", "\uff1b", "\uff01", "\u00b7", "\uff1f", "\u201c", "\u201d", "\uff09", "\uff08", "\u3010", "\u3011", "\uff3b", "\uff3d", "\u25cf"));
            return Collections.unmodifiableSet(defaultStopSet);
        }
    }
}

