/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.analyzer;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.HanlpWordSegmenter;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.SegmentingTokenizerBase;
import org.apache.lucene.util.AttributeFactory;

public class HanlpChineseTokenizer
extends SegmentingTokenizerBase {
    private static final BreakIterator SENTENCE_PROTO = BreakIterator.getSentenceInstance(Locale.ROOT);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final HanlpWordSegmenter segment;
    private Iterator<SegToken> tokens;

    public HanlpChineseTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, false);
    }

    public HanlpChineseTokenizer(AttributeFactory factory) {
        this(factory, false);
    }

    public HanlpChineseTokenizer(boolean isEnableIndexMode) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, isEnableIndexMode);
    }

    public HanlpChineseTokenizer(AttributeFactory factory, boolean isEnableIndexMode) {
        super(factory, (BreakIterator)SENTENCE_PROTO.clone());
        this.segment = new HanlpWordSegmenter(isEnableIndexMode);
    }

    protected void setNextSentence(int sentenceStart, int sentenceEnd) {
        String sentence = new String(this.buffer, sentenceStart, Math.subtractExact(sentenceEnd, sentenceStart));
        this.tokens = this.segment.segSentence(sentence, Math.addExact(this.offset, sentenceStart)).iterator();
    }

    protected boolean incrementWord() {
        if (this.tokens == null || !this.tokens.hasNext()) {
            return false;
        }
        SegToken token = this.tokens.next();
        this.clearAttributes();
        this.termAtt.copyBuffer(token.charArray, 0, token.charArray.length);
        this.offsetAtt.setOffset(this.correctOffset(token.startOffset), this.correctOffset(token.endOffset));
        this.typeAtt.setType("word");
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens = null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

