/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.analyzer;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.CustomEnglishAnalyzer;
import com.huawei.support.icscbb.commonsearch.lucene.analyzer.HanlpChineseAnalyzer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class SimpleAnalyzerFactory {
    private SimpleAnalyzerFactory() {
    }

    public static SimpleAnalyzerFactory getInstance() {
        return SingletonHandler.instance;
    }

    public Analyzer getAnalyzer(String lang) {
        Object analyzer = StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"zh") ? new HanlpChineseAnalyzer(true, true) : new CustomEnglishAnalyzer(CharArraySet.EMPTY_SET);
        return analyzer;
    }

    public Analyzer getHighLightAnalyzer(String lang) {
        Object analyzer = StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"zh") ? new HanlpChineseAnalyzer(true, true) : new CustomEnglishAnalyzer(CharArraySet.EMPTY_SET);
        return analyzer;
    }

    public boolean isStopWord(Analyzer analyzer, String word) {
        CharArraySet charArraySet = null;
        if (analyzer instanceof StopwordAnalyzerBase || analyzer instanceof SmartChineseAnalyzer || analyzer instanceof HanlpChineseAnalyzer) {
            try (StandardAnalyzer tempAnalyzer = new StandardAnalyzer();){
                StopwordAnalyzerBase stopwordAnalyzerBase = (StopwordAnalyzerBase)tempAnalyzer;
                charArraySet = stopwordAnalyzerBase.getStopwordSet();
            }
        }
        if (CollectionUtils.isEmpty(charArraySet)) {
            return false;
        }
        return charArraySet.contains((CharSequence)word);
    }

    public static void closeAnalyzer(Analyzer analyzer) {
        if (analyzer == null) {
            return;
        }
        analyzer.close();
    }

    private static class SingletonHandler {
        private static SimpleAnalyzerFactory instance = new SimpleAnalyzerFactory();

        private SingletonHandler() {
        }
    }
}

