/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.config;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public enum HdxMetaConfig {
    INSTANCE;

    private static final CommonLogger LOGGER;
    private static final int MAP_DEFAULT_SIZE = 120;
    private static final String RESOURCE_META_CONFIG = "/config/hdx_meta_config.xml";
    private static final String XML_LABEL_ATTR_TYPE = "type";
    private static final String XML_LABEL_ATTR_VALUE = "value";
    private static final String XML_LABEL_ATTR_NAME = "name";
    private static Map<String, String> sortNameMap;
    private static Map<String, String> bigSortMap;
    private static Map<String, String> smallSortMap;

    private static void parseConfigFile() {
        try (InputStream inputStream = HdxMetaConfig.class.getResourceAsStream(RESOURCE_META_CONFIG);){
            if (inputStream == null) {
                return;
            }
            Document doc = XmlDom4jUtils.getDocument((InputStream)inputStream);
            if (doc == null) {
                return;
            }
            Element root = doc.getRootElement();
            HdxMetaConfig.parseBigtypeEle(root.elementIterator("bigtype"));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]parseConfigFile error.", (Throwable)e);
        }
        catch (DocumentException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]parseConfigFile error.", e);
        }
    }

    private static void parseBigtypeEle(Iterator<Element> iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element categoryEle = iterator.next();
            if (categoryEle == null) continue;
            String fieldName = StringUtils.toRootLowerCase((String)StringUtils.trim((String)categoryEle.attributeValue("fieldName")));
            bigSortMap.put(categoryEle.attributeValue(XML_LABEL_ATTR_TYPE).trim(), fieldName);
            sortNameMap.put(HdxMetaConfig.getSortNameKey(fieldName, "en"), categoryEle.attributeValue("label").trim());
            sortNameMap.put(HdxMetaConfig.getSortNameKey(fieldName, "zh"), categoryEle.attributeValue(XML_LABEL_ATTR_VALUE).trim());
            HdxMetaConfig.parseSmalltypeEle(categoryEle.elementIterator("smalltype"));
        }
    }

    private static String getSortNameKey(String name, String lang) {
        return name + "@" + lang;
    }

    private static void parseSmalltypeEle(Iterator<Element> iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element smallType = iterator.next();
            if (smallType == null) continue;
            String smallTypeName = smallType.attributeValue(XML_LABEL_ATTR_NAME);
            sortNameMap.put(HdxMetaConfig.getSortNameKey(smallTypeName, "zh"), smallType.attributeValue(XML_LABEL_ATTR_VALUE));
            sortNameMap.put(HdxMetaConfig.getSortNameKey(smallTypeName, "en"), smallTypeName);
            HdxMetaConfig.parseTypeEle(smallType.elementIterator(XML_LABEL_ATTR_TYPE), smallTypeName);
        }
    }

    private static void parseTypeEle(Iterator<Element> itType, String smallTypeName) {
        if (itType == null) {
            return;
        }
        while (itType.hasNext()) {
            Element typeElement = itType.next();
            if (typeElement == null) continue;
            String typeName = typeElement.attributeValue(XML_LABEL_ATTR_NAME);
            smallSortMap.put(typeName.toLowerCase(Locale.ENGLISH).trim(), smallTypeName.toLowerCase(Locale.ENGLISH).trim());
        }
    }

    public void init() {
        HdxMetaConfig.parseConfigFile();
    }

    public String getBigSortFieldName(String value) {
        if (MapUtils.isEmpty(bigSortMap)) {
            return "";
        }
        return bigSortMap.get(value);
    }

    public String getSmallTypeValue(String value) {
        if (MapUtils.isEmpty(smallSortMap)) {
            return "";
        }
        return smallSortMap.get(value.toLowerCase(Locale.ENGLISH));
    }

    public Collection<String> getBigTypeNames() {
        return bigSortMap.values();
    }

    public String getSortName(String sortId, String lang) {
        return sortNameMap.get(HdxMetaConfig.getSortNameKey(sortId, lang));
    }

    static {
        LOGGER = CommonLoggerFactory.getLogger(HdxMetaConfig.class);
        sortNameMap = new HashMap<String, String>();
        bigSortMap = new HashMap<String, String>(120);
        smallSortMap = new HashMap<String, String>(120);
        INSTANCE.init();
    }
}

