/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.index.service;

import com.huawei.support.icscbb.commonsearch.lucene.index.dto.FieldInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.IndexTripleInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexWriterFactory;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.PhraseQueryUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;

public class IndexManager
implements Closeable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexManager.class);
    private static final long MAX_INDEX_MEMORY_SIZE = 0x700000L;
    private IndexWriter indexWriter;

    public IndexManager(String lang, String indexDir, boolean isCreate) throws IndexException {
        this.initIndexWrite(lang, indexDir, isCreate);
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    private void initIndexWrite(String lang, String indexDir, boolean isCreate) throws IndexException {
        this.indexWriter = IndexWriterFactory.getWriter(lang, indexDir, isCreate);
        if (this.indexWriter == null) {
            throw new IndexException("Create IndexManager failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(Collection<FieldInfoDto> fieldInfos) throws IndexException {
        Document document = new Document();
        for (FieldInfoDto fieldInfo : fieldInfos) {
            if (StringUtils.isBlank((CharSequence)fieldInfo.getFieldName())) continue;
            document.add((IndexableField)IndexUtils.getField(fieldInfo.getFieldName(), fieldInfo.getFieldValue(), fieldInfo.store(), TextField.class.getSimpleName()));
        }
        try {
            this.addDocument(document);
        }
        finally {
            document.clear();
        }
    }

    public void addTripleIndex(IndexTripleInfoDto indexTripleInfoDto) throws IndexException, IOException {
        if (indexTripleInfoDto == null) {
            return;
        }
        ArrayList<Document> documents = IndexUtils.createTripleIndexDocs(indexTripleInfoDto.getPath(), "resources/infocenter_service/kgdata/entity/" + indexTripleInfoDto.getFileName());
        if (documents.size() <= 0) {
            return;
        }
        for (int i = 0; i < documents.size(); ++i) {
            Document doc = documents.get(i);
            if (doc == null) continue;
            this.addDocument(doc);
            doc.clear();
        }
    }

    public long deleteIndex(FieldInfoDto fieldInfo, String lang) throws IndexException {
        long count;
        try {
            Query query = PhraseQueryUtils.getQuery(fieldInfo.getFieldName(), fieldInfo.getFieldValue(), lang);
            count = this.indexWriter.deleteDocuments(new Query[]{query});
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[deleteIndex]IOException", (Throwable)e);
            throw new IndexException("Error occurred while deleting index.");
        }
        catch (ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ParseException", (Throwable)e);
            throw new IndexException("Create query fail.");
        }
        return count;
    }

    public void updateIndex(FieldInfoDto fieldInfo, Collection<FieldInfoDto> fieldInfos) throws IndexException {
        Term term = new Term(fieldInfo.getFieldName(), fieldInfo.getFieldValue());
        Document document = new Document();
        for (FieldInfoDto element : fieldInfos) {
            if (StringUtils.isBlank((CharSequence)element.getFieldName())) continue;
            document.add((IndexableField)IndexUtils.getField(element.getFieldName(), element.getFieldValue(), element.store(), TextField.class.getSimpleName()));
        }
        try {
            this.indexWriter.updateDocument(term, (Iterable)document);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[updateIndex]IOException", (Throwable)e);
            throw new IndexException("Error occurred while updateIndex index.");
        }
    }

    public void updateIndex(String fieldName, String fieldValue, Document document) throws IndexException {
        Term term = new Term(fieldName, fieldValue);
        try {
            this.indexWriter.updateDocument(term, (Iterable)document);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[updateIndex]IOException", (Throwable)e);
            throw new IndexException("Error occurred while updateIndex index.");
        }
    }

    @Override
    public void close() {
        IndexWriterFactory.closeWriter(this.indexWriter);
    }

    public boolean isOpen() {
        return this.indexWriter.isOpen();
    }

    public void commit() throws IndexException {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[commit]IOException", (Throwable)e);
            throw new IndexException("Error occurred while commit.");
        }
    }

    public void addDocument(Document document) throws IndexException {
        try {
            this.indexWriter.addDocument((Iterable)document);
            if (this.indexWriter.ramBytesUsed() > 0x700000L) {
                this.commit();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[addDocument]IOException", (Throwable)e);
            throw new IndexException("addDocument error.");
        }
    }
}

