/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.index.service;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;

public class IndexWriterFactory {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexWriterFactory.class);
    private static final double RAM_BUFFER_SIZE_MB = 32.0;
    private static final int MAX_INDEXWRITER_CREATE_TIMES = 30;
    private static final int TIME_UNIT_TIME = 2;

    private IndexWriterFactory() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexWriter getWriter(String lang, String indexDir, boolean isCreate) throws IndexException {
        IndexWriter writer = null;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{lang, indexDir})) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "lang or indexDir is empty.");
            return writer;
        }
        Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getAnalyzer(lang);
        FSDirectory directory = null;
        try {
            File file = FileUtils.getFile((String[])new String[]{indexDir});
            File canonicalFile = file.getCanonicalFile();
            directory = FSDirectory.open((Path)canonicalFile.toPath());
            IndexWriterConfig config = new IndexWriterConfig(analyzer);
            config.setOpenMode(isCreate ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            config.setRAMBufferSizeMB(32.0);
            for (int writerCreateTime = 1; writerCreateTime <= 30; ++writerCreateTime) {
                try {
                    writer = new IndexWriter((Directory)directory, config);
                }
                catch (LockObtainFailedException e) {
                    CodeCCUtils.INSTANCE.warnLog(LOGGER, "Failed to create IndexWriter.");
                }
                if (writer != null) break;
                TimeUnit.SECONDS.sleep(2L);
            }
            if (writer != null) return writer;
        }
        catch (IOException e) {
            try {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "[getWriter]IOException", (Throwable)e);
                throw new IndexException("Error occurred when creating IndexWriter.");
                catch (InterruptedException e2) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "[getWriter]InterruptedException", (Throwable)e2);
                    throw new IndexException("An Interrupted error occurred when creating IndexWriter.");
                }
            }
            catch (Throwable throwable) {
                if (writer != null) throw throwable;
                StreamUtils.closeCloseable(directory);
                StreamUtils.closeCloseable((Closeable)analyzer);
                throw throwable;
            }
        }
        StreamUtils.closeCloseable((Closeable)directory);
        StreamUtils.closeCloseable((Closeable)analyzer);
        return writer;
    }

    public static void closeWriter(IndexWriter writer) {
        if (writer == null) {
            return;
        }
        if (!writer.isOpen()) {
            return;
        }
        Directory directory = writer.getDirectory();
        Analyzer analyzer = writer.getAnalyzer();
        StreamUtils.closeCloseable((Closeable)writer);
        StreamUtils.closeCloseable((Closeable)analyzer);
        StreamUtils.closeCloseable((Closeable)directory);
    }
}

