/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.index.util;

import com.huawei.support.icscbb.commonsearch.lucene.index.dto.FieldInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.TripleDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class IndexUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexUtils.class);
    private static final int SPECIAL_CHARACTER_ENCODEMAX = 32;
    private static final Pattern PATTEN_META_CHARSET = Pattern.compile("<meta((\\s)|(\\s[^>]*\\s))content=\\s*[\"'][^>]+?charset=([^>]+?)[\"'][^>]*>", 2);
    private static final int CHARSET_VAL_POS = 4;
    private static final int INDEX_OVER = -1;
    private static final int INDEX_TWO = 2;
    private static final String FIELD_STRING = "String";
    private static Map<String, String> specialCharacter;
    private static final Pattern TEXT_REPLACE_PATTERN;

    private IndexUtils() {
    }

    public static String replaceSpecialCharacter(String result) {
        String resultTemp = result;
        if (StringUtils.isBlank((CharSequence)resultTemp)) {
            return resultTemp;
        }
        for (Map.Entry<String, String> entry : specialCharacter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            resultTemp = resultTemp.replaceAll(String.valueOf((char)Integer.parseInt(key)), value);
        }
        return resultTemp;
    }

    public static String outBlankLine(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        String temp = str.replaceAll("[" + System.lineSeparator() + "]+", " ");
        return temp.replaceAll("\\s{2,}", " ");
    }

    public static String replaceSpecialAndBlank(String text) {
        String resultText = text;
        if (StringUtils.isBlank((CharSequence)resultText)) {
            return "";
        }
        for (Map.Entry<String, String> entry : specialCharacter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            resultText = resultText.replaceAll(String.valueOf((char)Integer.parseInt(key)), value);
        }
        resultText = resultText.replaceAll("[" + System.lineSeparator() + "]+", " ");
        resultText = resultText.replaceAll("\\s{2,}", " ");
        return resultText;
    }

    public static String getFileNameNotSuffix(String topicUrl) {
        if (StringUtils.isBlank((CharSequence)topicUrl)) {
            return "";
        }
        return FilenameUtils.getBaseName((String)topicUrl);
    }

    public static String getDocType(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        int dotIndex = StringUtils.lastIndexOf((CharSequence)url, (CharSequence)".");
        if (dotIndex == -1) {
            return "";
        }
        return StringUtils.substring((String)url, (int)dotIndex);
    }

    public static String getDocType(String docPath, String url) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docPath, url})) {
            return "";
        }
        String docType = IndexUtils.getDocType(url);
        if (StringUtils.equalsAny((CharSequence)docType, (CharSequence[])new CharSequence[]{".doc", ".ppt", ".xls"})) {
            try (InputStream inputStream = ZipFilePool.getInputStream((String)docPath, (String)url);
                 InputStream is = FileMagic.prepareToCheckMagic((InputStream)inputStream);){
                FileMagic fm = FileMagic.valueOf((InputStream)is);
                if (fm != FileMagic.OLE2) {
                    docType = docType + "x";
                    CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]real doc type of [{0}] is [{1}].", new Object[]{url, docType});
                }
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while get Doc Type.");
            }
        }
        return docType;
    }

    public static void addFieldToFieldInfos(String fieldName, String fieldValue, Collection<FieldInfoDto> fieldInfos) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return;
        }
        String value = fieldValue;
        if (StringUtils.isBlank((CharSequence)value)) {
            value = "";
        }
        FieldInfoDto field = new FieldInfoDto(fieldName, value);
        fieldInfos.add(field);
    }

    public static void addContents(String fieldName, String str, Collection<FieldInfoDto> fieldInfos) {
        String result = IndexUtils.textReplace(str);
        IndexUtils.addFieldToFieldInfos(fieldName, result, fieldInfos);
    }

    public static void addTitle(String fieldName, String str, Collection<FieldInfoDto> fieldInfos) {
        String result = IndexUtils.textReplace(str);
        IndexUtils.addFieldToFieldInfos(fieldName, result, fieldInfos);
    }

    public static Field getField(String name, String value, Field.Store store, String fieldType) {
        if (StringUtils.equals((CharSequence)fieldType, (CharSequence)TextField.class.getSimpleName())) {
            return new TextField(name, StringUtils.isBlank((CharSequence)value) ? "" : value, store);
        }
        return new StringField(name, StringUtils.isBlank((CharSequence)value) ? "" : value, store);
    }

    public static String getElementText(Element element) {
        if (element == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(" ");
        List nodes = element.childNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return stringJoiner.toString();
        }
        for (Node item : nodes) {
            if (item instanceof TextNode) {
                stringJoiner.add(((TextNode)item).text());
                continue;
            }
            if (!(item instanceof Element)) continue;
            stringJoiner.add(((Element)item).text());
        }
        return stringJoiner.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<Document> createTripleIndexDocs(String sourcePath, String indexPath) throws IndexException {
        documents = new ArrayList<Document>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{indexPath, indexPath})) {
            CodeCCUtils.INSTANCE.errorLog(IndexUtils.LOGGER, "indexPath or indexPath is empty.");
            return documents;
        }
        try {
            zipFile = new ZipFile(new File(sourcePath), "GBK");
            var4_5 = null;
            try {
                block80: {
                    block81: {
                        block82: {
                            block86: {
                                block87: {
                                    block83: {
                                        block84: {
                                            block85: {
                                                block78: {
                                                    block79: {
                                                        zipEntry = zipFile.getEntry(indexPath);
                                                        try {
                                                            in = zipFile.getInputStream(zipEntry);
                                                            var7_11 = null;
                                                            try {
                                                                zipInput = new InputStreamReader(zipFile.getInputStream(zipEntry), "UTF-8");
                                                                var9_15 = null;
                                                                try {
                                                                    zipBuffer = new BufferedReader(zipInput);
                                                                    var11_19 = null;
                                                                    try {
                                                                        if (in == null) {
                                                                            CodeCCUtils.INSTANCE.errorLog(IndexUtils.LOGGER, "in is empty.");
                                                                            var12_20 = documents;
                                                                            if (zipBuffer == null) break block78;
                                                                            if (var11_19 == null) break block79;
                                                                        }
                                                                        ** GOTO lbl-1000
                                                                    }
                                                                    catch (Throwable var12_23) {
                                                                        var11_19 = var12_23;
                                                                        throw var12_23;
                                                                    }
                                                                }
                                                                catch (Throwable var10_18) {
                                                                    var9_15 = var10_18;
                                                                    throw var10_18;
                                                                }
                                                            }
                                                            catch (Throwable var8_14) {
                                                                var7_11 = var8_14;
                                                                throw var8_14;
                                                            }
                                                        }
                                                        catch (IOException e) {
                                                            throw new IndexException("InputStream fail.", e);
                                                        }
                                                        catch (Throwable var17_39) {
                                                            throw var17_39;
                                                        }
                                                        try {
                                                            zipBuffer.close();
                                                        }
                                                        catch (Throwable var13_24) {
                                                            var11_19.addSuppressed(var13_24);
                                                        }
                                                        break block78;
                                                    }
                                                    zipBuffer.close();
                                                }
                                                if (zipInput == null) break block83;
                                                if (var9_15 == null) break block84;
                                                break block85;
                                                catch (Throwable var19_41) {
                                                    throw var19_41;
                                                }
                                            }
                                            try {
                                                zipInput.close();
                                            }
                                            catch (Throwable var13_25) {
                                                var9_15.addSuppressed(var13_25);
                                            }
                                            break block83;
                                        }
                                        zipInput.close();
                                    }
                                    if (in == null) return var12_20;
                                    if (var7_11 == null) break block86;
                                    break block87;
                                    catch (Throwable var21_43) {
                                        throw var21_43;
                                    }
                                }
                                try {
                                    in.close();
                                    return var12_20;
                                }
                                catch (Throwable var13_27) {
                                    var7_11.addSuppressed(var13_27);
                                    return var12_20;
                                }
                            }
                            in.close();
                            return var12_20;
lbl-1000:
                            // 1 sources

                            {
                                check = IndexUtils.checkFileSize(in);
                                if (check) break block80;
                                CodeCCUtils.INSTANCE.errorLog(IndexUtils.LOGGER, "file is too big.");
                                var13_29 = documents;
                                if (zipBuffer == null) break block81;
                                if (var11_19 == null) break block82;
                            }
                            try {
                                zipBuffer.close();
                            }
                            catch (Throwable var14_31) {
                                var11_19.addSuppressed(var14_31);
                            }
                            break block81;
                        }
                        zipBuffer.close();
                    }
                    if (zipInput != null) {
                        if (var9_15 != null) {
                            try {
                                zipInput.close();
                            }
                            catch (Throwable var14_32) {
                                var9_15.addSuppressed(var14_32);
                            }
                        } else {
                            zipInput.close();
                        }
                    }
                    if (in == null) return var13_29;
                    if (var7_11 != null) {
                        try {
                            in.close();
                            return var13_29;
                        }
                        catch (Throwable var14_34) {
                            var7_11.addSuppressed(var14_34);
                            return var13_29;
                        }
                    }
                    in.close();
                    return var13_29;
                }
                ** try [egrp 22[TRYBLOCK] [11, 14 : 449->564)] { 
lbl115:
                // 1 sources

                tripleDtos = IndexUtils.readCsv(zipBuffer);
                var14_36 = tripleDtos.iterator();
                while (var14_36.hasNext() != false) {
                    tripleDto = var14_36.next();
                    doc = new Document();
                    doc.add((IndexableField)IndexUtils.getField("head", tripleDto.getHeadEntity(), Field.Store.YES, "String"));
                    doc.add((IndexableField)IndexUtils.getField("relation", tripleDto.getRelation(), Field.Store.YES, "String"));
                    doc.add((IndexableField)IndexUtils.getField("tail", tripleDto.getTailEntity(), Field.Store.YES, "String"));
                    documents.add(doc);
                }
                return documents;
lbl127:
                // 1 sources

                finally {
                    if (zipBuffer != null) {
                        if (var11_19 != null) {
                            try {
                                zipBuffer.close();
                            }
                            catch (Throwable var12_22) {
                                var11_19.addSuppressed(var12_22);
                            }
                        } else {
                            zipBuffer.close();
                        }
                    }
                }
            }
            catch (Throwable var5_8) {
                var4_5 = var5_8;
                throw var5_8;
            }
            finally {
                if (zipFile != null) {
                    if (var4_5 != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable var13_28) {
                            var4_5.addSuppressed(var13_28);
                        }
                    } else {
                        zipFile.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IndexException("zipFile fail.", e);
        }
    }

    private static boolean checkFileSize(InputStream zis) throws IOException {
        int total = 0;
        byte[] data = new byte[512];
        int count = zis.read(data, 0, 512);
        while (count != -1) {
            if ((total += count) > 0x6400000) {
                return false;
            }
            count = zis.read(data, 0, 512);
        }
        return true;
    }

    private static ArrayList<TripleDto> readCsv(BufferedReader reader) throws IndexException {
        ArrayList<TripleDto> tripleDtos = new ArrayList<TripleDto>();
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                String[] strArr = line.split(",");
                if (strArr.length < 4) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "file is out of limit.");
                    continue;
                }
                String head = strArr[0].replace("\"", "");
                String relation = strArr[1].replace("\"", "");
                String tail = strArr[2].replace("\"", "");
                TripleDto tripleDto = new TripleDto();
                tripleDto.setHeadEntity(head);
                tripleDto.setRelation(relation);
                tripleDto.setTailEntity(tail);
                tripleDtos.add(tripleDto);
            }
        }
        catch (IOException e) {
            throw new IndexException("create TripleIndexDocs.", e);
        }
        return tripleDtos;
    }

    public static String textReplace(String text) {
        String result = text;
        Matcher matcher = TEXT_REPLACE_PATTERN.matcher(result);
        return matcher.replaceAll(",");
    }

    static {
        TEXT_REPLACE_PATTERN = Pattern.compile("[\uff0c]");
        specialCharacter = new HashMap<String, String>();
        for (int index = 1; index <= 32; ++index) {
            specialCharacter.put(String.valueOf(index), " ");
        }
    }
}

