/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.convert;

public class SearchConvert {
    protected static final String AND_TAG = " and ";
    protected static final String NOT_TAG = " not ";
    protected static final String OR_TAG = " or ";
    protected static final String SEARCH_AND_TAG = " AND ";
    protected static final String SEARCH_NOT_TAG = " NOT ";
    protected static final String SEARCH_OR_TAG = " OR ";
    protected static final String STANDARD_OR_TAG = "OR";
    protected static final String UN_STANDARD_OR_TAG = "||";
    protected static final String LEFT_QUOTE = "(";
    protected static final String RIGHT_QUOTE = ")";
    protected static final String DOUBLE_QUOTATION_MARKS = "\"";
    private static final int SECOND_SEARCHCHAR_POS = 2;

    public static String handleField(String queryString) {
        String result = queryString;
        if (result.indexOf(STANDARD_OR_TAG) > 0) {
            result = SearchConvert.handleStandardField(result);
        }
        if (result.indexOf(UN_STANDARD_OR_TAG) > 0) {
            result = SearchConvert.handleUnStandardField(result);
        }
        if (result.indexOf(SEARCH_AND_TAG) > 0 && result.indexOf(SEARCH_NOT_TAG) > 0) {
            result = result.replaceAll(SEARCH_NOT_TAG, NOT_TAG);
        }
        return result;
    }

    public static String handleStandardField(String queryString) {
        if (!(queryString.startsWith(DOUBLE_QUOTATION_MARKS) || queryString.endsWith(DOUBLE_QUOTATION_MARKS) || queryString.startsWith(LEFT_QUOTE) || queryString.endsWith(RIGHT_QUOTE))) {
            return SearchConvert.getString(queryString, STANDARD_OR_TAG, SEARCH_OR_TAG);
        }
        return queryString;
    }

    private static String getString(String result, String standardOrTag, String orType) {
        String temp = result;
        temp = temp.replaceAll("\\+", "");
        int id = temp.indexOf(standardOrTag);
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(LEFT_QUOTE);
        strBuffer.append(temp.substring(0, id).trim());
        strBuffer.append(RIGHT_QUOTE);
        strBuffer.append(orType);
        strBuffer.append(LEFT_QUOTE);
        strBuffer.append(temp.substring(id + 2).trim());
        strBuffer.append(RIGHT_QUOTE);
        return strBuffer.toString();
    }

    public static String handleUnStandardField(String queryString) {
        if (!(queryString.startsWith(DOUBLE_QUOTATION_MARKS) || queryString.endsWith(DOUBLE_QUOTATION_MARKS) || queryString.startsWith(LEFT_QUOTE) || queryString.endsWith(RIGHT_QUOTE))) {
            return SearchConvert.getString(queryString, UN_STANDARD_OR_TAG, " || ");
        }
        return queryString;
    }
}

