/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.dto;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class TokenGroup {
    private static final int TOKEN_NUM = 50;
    private int startOffset = 0;
    private int endOffset = 0;
    private int numTokens = 0;
    private float tot;
    private OffsetAttribute offsetAtt;
    private int matchStartOffset;
    private int matchEndOffset;

    public TokenGroup(TokenStream tokenStream) {
        this.offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
    }

    public void addToken(float score) {
        if (this.numTokens >= 50) {
            return;
        }
        int termStartOffset = this.offsetAtt.startOffset();
        int termEndOffset = this.offsetAtt.endOffset();
        if (this.numTokens == 0) {
            this.endOffset = termEndOffset;
            this.startOffset = termStartOffset;
            this.matchEndOffset = termEndOffset;
            this.matchStartOffset = termStartOffset;
            this.tot += score;
        } else {
            this.endOffset = Math.max(this.endOffset, termEndOffset);
            this.startOffset = Math.min(this.startOffset, termStartOffset);
            if (Float.compare(score, 0.0f) > 0) {
                if (Float.compare(this.tot, 0.0f) == 0) {
                    this.matchEndOffset = termEndOffset;
                    this.matchStartOffset = termStartOffset;
                } else {
                    this.matchEndOffset = Math.max(this.matchEndOffset, termEndOffset);
                    this.matchStartOffset = Math.min(this.matchStartOffset, termStartOffset);
                }
                this.tot += score;
            }
        }
        ++this.numTokens;
    }

    public boolean isDistinct() {
        return this.offsetAtt.startOffset() >= this.endOffset;
    }

    public void clear() {
        this.numTokens = 0;
        this.tot = 0.0f;
    }

    public int getStartOffset() {
        return this.matchStartOffset;
    }

    public int getEndOffset() {
        return this.matchEndOffset;
    }

    public float getTotalScore() {
        return this.tot;
    }

    public int getNumTokens() {
        return this.numTokens;
    }
}

