/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.highlight;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;

public class CommonHighlighter {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CommonHighlighter.class);
    private static final int SUMMARY_SHOW_MAX_LENGTH = 100;
    private static final String SUFFIX = "</span>";
    private static final String PREFIX_EN = "<span class=\"h_en\">";
    private static final String PREFIX_ZH = "<span class=\"h_zh\">";
    private static final String FRAGMENT_SEPARATOR_START = "<b>";
    private static final String FRAGMENT_SEPARATOR_END = "</b>";
    private static final String FRAGMENT_SEPARATOR = "&nbsp;<b>...</b>&nbsp;";
    private Highlighter highlighter;
    private Analyzer analyzer;

    public CommonHighlighter(Query query, String lang) {
        String defaultPreFix = "zh".equalsIgnoreCase(lang) ? PREFIX_ZH : PREFIX_EN;
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(defaultPreFix, SUFFIX);
        this.analyzer = SimpleAnalyzerFactory.getInstance().getHighLightAnalyzer(lang);
        this.highlighter = new Highlighter((Formatter)formatter, (Scorer)new QueryScorer(query));
        this.highlighter.setMaxDocCharsToAnalyze(15450);
    }

    public String highlight(String fieldName, String text, int maxNumFragments) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return this.getBestFragment(fieldName, text.trim(), maxNumFragments);
    }

    public String delHighLightStyle(String highlightText) {
        if (StringUtils.isBlank((CharSequence)highlightText)) {
            return highlightText;
        }
        return highlightText.replaceAll(PREFIX_EN, "").replaceAll(PREFIX_ZH, "").replaceAll(SUFFIX, "");
    }

    private String getBestFragment(String fieldName, String subText, int maxNumFragments) {
        String highlightText = "";
        try (StringReader stringReader = new StringReader(subText);
             TokenStream tokenStream = this.analyzer.tokenStream(fieldName, (Reader)stringReader);){
            Object[] highlightTexts = this.highlighter.getBestFragments(tokenStream, subText, maxNumFragments);
            if (ArrayUtils.isNotEmpty((Object[])highlightTexts)) {
                highlightText = StringUtils.join((Object[])highlightTexts, (String)FRAGMENT_SEPARATOR);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Text highlight error.", (Throwable)e);
        }
        catch (InvalidTokenOffsetsException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Text highlight error.", (Throwable)e);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Text highlight error.", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)highlightText) && (highlightText = subText).length() > 100) {
            highlightText = highlightText.substring(0, 100).trim();
        }
        return this.addSeparatorToContent(fieldName, highlightText);
    }

    private String addSeparatorToContent(String fieldName, String highlightText) {
        String content = highlightText;
        if ("t_content".equals(fieldName)) {
            content = FRAGMENT_SEPARATOR + content + FRAGMENT_SEPARATOR;
        }
        return content;
    }
}

