/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.pool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.SearchUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.file.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SearcherPool {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SearcherPool.class);
    private Cache<String, IndexReader> cachePool;
    private boolean checkUpdateFlag;

    public SearcherPool() {
        this(20, 30, true);
    }

    public SearcherPool(int maxCacheSize, int cacheExpireTime, boolean checkUpdateFlag) {
        this.cachePool = this.initCachePool(maxCacheSize, cacheExpireTime);
        this.checkUpdateFlag = checkUpdateFlag;
    }

    private Cache<String, IndexReader> initCachePool(int maxCacheSize, int cacheExpireTime) {
        RemovalListener listener = notification -> {
            String fileName = FileUtils.getFile((String[])new String[]{(String)notification.getKey()}).getName();
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "data key:" + fileName + " is removed from localrecord!");
            IndexReader value = (IndexReader)notification.getValue();
            if (value != null) {
                StreamUtils.closeCloseable((Closeable)value);
            }
        };
        return CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterAccess((long)cacheExpireTime, TimeUnit.MINUTES).removalListener(listener).build();
    }

    public Optional<IndexSearcher> getSearcher(Collection<String> paths) throws SearchException {
        HashSet<String> pathSet = this.removeIllegalPaths(paths);
        if (CollectionUtils.isEmpty(pathSet)) {
            return Optional.empty();
        }
        Optional<IndexReader> indexReaderOpt = this.getIndexReader(pathSet);
        return indexReaderOpt.map(IndexSearcher::new);
    }

    public void removeIndexReader(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        String filePath = IcsFileUtils.getCanonicalPath((File)file);
        this.cachePool.invalidate((Object)filePath);
    }

    private HashSet<String> removeIllegalPaths(Collection<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return new HashSet<String>();
        }
        HashSet<String> pathSet = new HashSet<String>();
        int cpuNums = Runtime.getRuntime().availableProcessors();
        for (String path : paths) {
            pathSet.addAll(SearchUtils.getIndexDirs(path, cpuNums));
        }
        return pathSet;
    }

    private Optional<IndexReader> getIndexReader(Set<String> paths) throws SearchException {
        ArrayList<Object> indexReaderList = new ArrayList<Object>();
        for (String path : paths) {
            Optional<Object> readerOpt = Optional.empty();
            try {
                readerOpt = this.getIndexReader(path);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "get IndexReader failed, maybe not illegal index dir.", (Throwable)e);
            }
            if (!readerOpt.isPresent()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to get IndexReader.");
                continue;
            }
            indexReaderList.add(readerOpt.get());
        }
        indexReaderList.removeIf(indexReader -> indexReader.getRefCount() == 0);
        if (CollectionUtils.isEmpty(indexReaderList)) {
            throw new SearchException("Create IndexReader from all paths failed.");
        }
        if (indexReaderList.size() == 1) {
            return Optional.of(indexReaderList.get(0));
        }
        return this.getMultiReader(indexReaderList.toArray(new IndexReader[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Optional<IndexReader> getIndexReader(String path) throws IOException {
        IndexReader oldReader = (IndexReader)this.cachePool.getIfPresent((Object)path);
        if (oldReader == null) {
            Class<SearcherPool> clazz = SearcherPool.class;
            // MONITORENTER : com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPool.class
            oldReader = (IndexReader)this.cachePool.getIfPresent((Object)path);
            if (oldReader == null) {
                oldReader = this.createIndexReader(path);
            }
            // MONITOREXIT : clazz
        }
        if (oldReader == null) {
            return Optional.empty();
        }
        if (!this.checkUpdateFlag) return Optional.of(oldReader);
        DirectoryReader reader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)oldReader));
        if (reader == null) return Optional.of(oldReader);
        this.cachePool.put((Object)path, (Object)reader);
        oldReader = reader;
        return Optional.of(oldReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader createIndexReader(String path) {
        FSDirectory fsDirectory = null;
        DirectoryReader oldReader = null;
        try {
            fsDirectory = FSDirectory.open((Path)Paths.get(path, new String[0]));
            oldReader = DirectoryReader.open((Directory)fsDirectory);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to create IndexReader.");
        }
        finally {
            if (oldReader == null) {
                StreamUtils.closeCloseable((Closeable)fsDirectory);
            } else {
                this.cachePool.put((Object)path, (Object)oldReader);
            }
        }
        return oldReader;
    }

    private Optional<IndexReader> getMultiReader(IndexReader[] indexReaders) throws SearchException {
        try {
            return Optional.of(new MultiReader(indexReaders));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[getMultiReader]IOException", (Throwable)e);
            throw new SearchException("Create multiReader failed.");
        }
    }
}

