/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.pool;

import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPool;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SearcherPoolFactory {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SearcherPoolFactory.class);
    private static SearcherPoolFactory searcherPoolFactory = new SearcherPoolFactory();
    private static Map<String, SearcherPool> searcherPoolMap = new ConcurrentHashMap<String, SearcherPool>();
    private boolean checkUpdateFlag = true;

    private SearcherPoolFactory() {
    }

    public void setCheckUpdateFlag(boolean flag) {
        this.checkUpdateFlag = flag;
    }

    public SearcherPool getPool(String type, int cacheSize, int expireTime) {
        SearcherPool searcherPool = searcherPoolMap.get(type);
        if (searcherPool != null) {
            return searcherPool;
        }
        if (cacheSize > 0 && expireTime > 0) {
            searcherPool = new SearcherPool(cacheSize, expireTime, this.checkUpdateFlag);
            searcherPoolMap.put(type, searcherPool);
        } else {
            searcherPool = searcherPoolMap.get("default");
        }
        return searcherPool;
    }

    public boolean deleteCache(String path, String taskType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path, taskType})) {
            return false;
        }
        SearcherPool searcherPool = searcherPoolMap.get(taskType);
        if (searcherPool == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "DeleteIndexReaderCache fail. Pool of {0} is not exist.", new Object[]{taskType});
            return false;
        }
        searcherPool.removeIndexReader(path);
        return true;
    }

    public static SearcherPoolFactory getInstance() {
        return searcherPoolFactory;
    }

    static {
        searcherPoolMap.put("default", new SearcherPool());
    }
}

