/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryCondition {
    private Map<String, Set<String>> conditions = new HashMap<String, Set<String>>();

    public QueryCondition(String editTypeKey, List<String> smallTypeList) {
        if (StringUtils.isBlank((CharSequence)editTypeKey) || CollectionUtils.isEmpty(smallTypeList)) {
            return;
        }
        for (String smallType : smallTypeList) {
            if (StringUtils.isBlank((CharSequence)smallType)) continue;
            Set<String> values = this.conditions.get(editTypeKey);
            if (values == null) {
                values = new HashSet<String>();
                this.conditions.put(editTypeKey, values);
            }
            values.add(smallType);
        }
    }

    public String[] getValue(String name) {
        String[] result = new String[]{};
        if (name == null) {
            return result;
        }
        Set<String> values = this.conditions.get(name);
        return values == null ? result : values.toArray(new String[0]);
    }

    public Set<Map.Entry<String, Set<String>>> entrySet() {
        return this.conditions.entrySet();
    }

    public QueryCondition() {
    }

    public Map<String, Set<String>> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, Set<String>> conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryCondition)) {
            return false;
        }
        QueryCondition other = (QueryCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Set<String>> this$conditions = this.getConditions();
        Map<String, Set<String>> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Set<String>> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    public String toString() {
        return "QueryCondition(conditions=" + this.getConditions() + ")";
    }
}

