/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPool;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPoolContext;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryBase;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SearchManagerBase {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SearchManagerBase.class);
    private static final int KEYWORDS_MAX_NUM = 30;
    private static final int ARRAY_DEFAULT_SIZE = 50;
    private static final int SORT_MINUS_ONE = -1;

    public SearchResult getSearchResult(ParamBase paramBase, QueryBase queryBase, Collection<String> indexDirs) throws SearchException, ParseException {
        this.preProcess(paramBase);
        Optional<IndexSearcher> searcherOpt = this.getSearchPool(paramBase).getSearcher(indexDirs);
        if (!searcherOpt.isPresent()) {
            throw new SearchException("Get Searcher failed.");
        }
        IndexSearcher indexSearcher = searcherOpt.get();
        Query query = queryBase.create(paramBase);
        int count = this.getTotalNumber(indexSearcher, query);
        TopDocs hits = this.getTopDocs(indexSearcher, query, this.getSearchRange(paramBase));
        return this.parseHits(indexSearcher, hits, count, paramBase);
    }

    private int getSearchRange(ParamBase paramBase) {
        int pageIndex = paramBase.getPageIndex();
        int pageSize = paramBase.getPageSize();
        int firstPageSize = this.getFirstPageSize(paramBase.getFirstPageSize(), pageSize);
        if (pageIndex == 1) {
            return firstPageSize;
        }
        return (pageIndex - 1) * pageSize + firstPageSize;
    }

    protected SearcherPool getSearchPool(ParamBase paramBase) {
        return SearcherPoolContext.getPool("default", paramBase.getPoolSize(), paramBase.getExpireTime());
    }

    protected void preProcess(ParamBase paramBase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> searchDocuments(ParamBase paramBase, QueryBase queryBase, Collection<String> indexDirs) throws SearchException, IOException {
        List<Document> documents;
        IndexSearcher searcher = null;
        SearcherManager searcherManager = null;
        try {
            if (indexDirs.size() == 1) {
                searcherManager = this.getSearcherMr(indexDirs);
                searcher = (IndexSearcher)searcherManager.acquire();
            } else {
                Optional<IndexSearcher> searcherOpt = this.getSearchPool(paramBase).getSearcher(indexDirs);
                if (searcherOpt.isPresent()) {
                    searcher = searcherOpt.get();
                }
            }
            if (searcher == null) {
                throw new SearchException("Get indexSearcher fail.");
            }
            TopDocs hits = this.getTopDocs(searcher, queryBase.create(paramBase), searcher.getIndexReader().maxDoc());
            documents = this.getDocuments(searcher, hits);
        }
        catch (Throwable throwable) {
            this.closeSearcherMr(searcherManager, searcher);
            throw throwable;
        }
        this.closeSearcherMr(searcherManager, searcher);
        return documents;
    }

    private SearcherManager getSearcherMr(Collection<String> indexDirs) throws IOException {
        String indexDir = new ArrayList<String>(indexDirs).get(0);
        FSDirectory fsDirectory = FSDirectory.open((Path)Paths.get(indexDir, new String[0]));
        SearcherManager searcherManager = new SearcherManager((Directory)fsDirectory, null);
        searcherManager.maybeRefresh();
        return searcherManager;
    }

    private void closeSearcherMr(SearcherManager searcherManager, IndexSearcher indexSearcher) throws SearchException {
        if (searcherManager == null) {
            return;
        }
        try {
            searcherManager.release((Object)indexSearcher);
            searcherManager.close();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[closeSearcherMr]IOException", (Throwable)e);
            throw new SearchException("searcherManager close error.");
        }
    }

    private List<Document> getDocuments(IndexSearcher searcher, TopDocs hits) {
        if (hits == null || ArrayUtils.isEmpty((Object[])hits.scoreDocs)) {
            return Collections.emptyList();
        }
        return Arrays.stream(hits.scoreDocs).map(scoreDoc -> {
            Document document = null;
            try {
                document = searcher.doc(scoreDoc.doc);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "[getDocuments]IOException", (Throwable)e);
            }
            return document;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected TopDocs getTopDocs(IndexSearcher indexSearcher, Query query, int range) throws SearchException {
        TopDocs hits;
        if (query == null || indexSearcher.getIndexReader().maxDoc() == 0) {
            throw new SearchException("Init query failed.");
        }
        try {
            hits = indexSearcher.search(query, range);
        }
        catch (IOException e) {
            throw new SearchException("Search failed. ", e);
        }
        return hits;
    }

    protected int getTotalNumber(IndexSearcher indexSearcher, Query query) throws SearchException {
        int count;
        if (query == null) {
            throw new SearchException("Init query failed.");
        }
        try {
            count = indexSearcher.count(query);
        }
        catch (IOException e) {
            throw new SearchException("Search failed. ", e);
        }
        return count;
    }

    protected int getPageStart(int pageIndex, int pageSize, int firstPageSize) {
        if (pageIndex == 1) {
            return 0;
        }
        return (pageIndex - 2) * pageSize + this.getFirstPageSize(firstPageSize, pageSize);
    }

    protected int getPageEnd(int pageIndex, int pageSize, int totalHits, int firstPageSize) {
        int firstPageSizeTemp = this.getFirstPageSize(firstPageSize, pageSize);
        if (pageIndex == 1) {
            return Math.min(firstPageSizeTemp, totalHits);
        }
        return Math.min((pageIndex - 1) * pageSize + firstPageSizeTemp, totalHits);
    }

    private int getFirstPageSize(int firstPageSize, int defaultPageSize) {
        return firstPageSize == 0 ? defaultPageSize : firstPageSize;
    }

    protected Set<String> keywordsSort(Set<String> keywords) {
        TreeSet<String> resultSet = new TreeSet<String>((o1, o2) -> o1.length() > o2.length() ? -1 : 1);
        resultSet.addAll(keywords);
        return resultSet;
    }

    protected Set<String> subSet(Set<String> objSet) {
        if (CollectionUtils.isEmpty(objSet)) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.limit(objSet, (int)30));
    }

    protected SearchResult parseHits(IndexSearcher searcher, TopDocs hits, int count, ParamBase paramBase) throws SearchException, ParseException {
        return null;
    }

    public int count(ParamBase paramBase, QueryBase queryBase, Collection<String> indexDirs) throws SearchException {
        Optional<IndexSearcher> searcherOpt = this.getSearchPool(paramBase).getSearcher(indexDirs);
        if (!searcherOpt.isPresent()) {
            throw new SearchException("Get Searcher failed.");
        }
        return this.getTotalNumber(searcherOpt.get(), queryBase.create(paramBase));
    }
}

