/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.util;

import com.huawei.wsf.core.HWDecoder;
import com.huawei.wsf.core.HWEncoder;
import org.apache.commons.lang3.StringUtils;

public class HighlightUtils {
    private static final String SUFFIX = "</span>";
    private static final String ENCODE_SUFFIX = HWEncoder.encodeForHTML((String)"</span>");
    private static final String PREFIX_EN = "<span class=\"h_en\">";
    private static final String PREFIX_ZH = "<span class=\"h_zh\">";
    private static final String FRAGMENT_SEPARATOR_START = "<b>";
    private static final String ENCODE_FRAGMENT_SEPARATOR_START = HWEncoder.encodeForHTML((String)"<b>");
    private static final String FRAGMENT_SEPARATOR_END = "</b>";
    private static final String ENCODE_FRAGMENT_SEPARATOR_END = HWEncoder.encodeForHTML((String)"</b>");

    public static String encodeHighLightPieces(String content, String lang) {
        String defaultPreFix = "zh".equalsIgnoreCase(lang) ? PREFIX_ZH : PREFIX_EN;
        String highPieces = HWDecoder.decodeForHTML((String)content);
        highPieces = HWEncoder.encodeForHTML((String)highPieces);
        return HighlightUtils.restoreFormatLabel(highPieces, defaultPreFix);
    }

    public static String restoreFormatLabel(String highlightText, String defaultPreFix) {
        if (StringUtils.isBlank((CharSequence)highlightText)) {
            return highlightText;
        }
        String encodeDefaultPreFix = HWEncoder.encodeForHTML((String)defaultPreFix);
        String text = highlightText.replaceAll(encodeDefaultPreFix, defaultPreFix);
        text = text.replaceAll(ENCODE_SUFFIX, SUFFIX);
        text = text.replaceAll(ENCODE_FRAGMENT_SEPARATOR_START, FRAGMENT_SEPARATOR_START);
        return text.replaceAll(ENCODE_FRAGMENT_SEPARATOR_END, FRAGMENT_SEPARATOR_END);
    }
}

