/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.util;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryCondition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public class PhraseQueryUtils {
    private static final String QUOT_MARKS = "\"";

    private PhraseQueryUtils() {
    }

    public static Query buildExtraQuery(List<QueryCondition> extraConditions, Analyzer analyzer, String searchType) throws ParseException {
        Query query = null;
        if (CollectionUtils.isEmpty(extraConditions)) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (QueryCondition condition : extraConditions) {
            BooleanQuery.Builder subBuilder = new BooleanQuery.Builder();
            for (Map.Entry<String, Set<String>> it : condition.entrySet()) {
                subBuilder.add(PhraseQueryUtils.buildMultiQuery(StringUtils.toRootLowerCase((String)it.getKey()), it.getValue(), analyzer, searchType), BooleanClause.Occur.SHOULD);
            }
            builder.add((Query)subBuilder.build(), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    private static Query buildMultiQuery(String field, Set<String> values, Analyzer analyzer, String searchType) throws ParseException {
        if (StringUtils.equals((CharSequence)field, (CharSequence)"topicidstring") && StringUtils.equals((CharSequence)searchType, (CharSequence)"search-type-navi")) {
            return new TermInSetQuery(field, (Collection)values.stream().filter(StringUtils::isNotBlank).map(BytesRef::new).collect(Collectors.toList()));
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        QueryParser queryParser = new QueryParser(field, analyzer);
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        for (String value : values) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            builder.add(queryParser.parse(QUOT_MARKS + value + QUOT_MARKS), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public static Query attachExtraQuery(Query baseQuery, Query extraQuery) {
        if (extraQuery == null) {
            return baseQuery;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(baseQuery, BooleanClause.Occur.MUST);
        builder.add(extraQuery, BooleanClause.Occur.MUST);
        return builder.build();
    }

    public static BooleanQuery getCommonQuery(ParamBase paramBase, String queryString) throws ParseException {
        List<SearchField> highLightFields = paramBase.getSearchFields();
        HashMap searchBoost = new HashMap();
        highLightFields.forEach(searchField -> searchBoost.put(searchField.getFieldName(), Float.valueOf(searchField.getWeight())));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Map.Entry it : searchBoost.entrySet()) {
            Query query = PhraseQueryUtils.getQuery((String)it.getKey(), queryString, paramBase.getLang());
            if (query == null) continue;
            builder.add((Query)new BoostQuery(query, ((Float)it.getValue()).floatValue()), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public static MultiFieldQueryParser getMultiFieldQueryParser(ParamBase paramBase, Analyzer analyzer) {
        List<SearchField> highLightFields = paramBase.getSearchFields();
        HashMap searchBoost = new HashMap();
        HashSet fieldsSet = new HashSet();
        highLightFields.forEach(searchField -> {
            fieldsSet.add(searchField.getFieldName());
            searchBoost.put(searchField.getFieldName(), Float.valueOf(searchField.getWeight()));
        });
        String[] fields = fieldsSet.toArray(new String[0]);
        return new MultiFieldQueryParser(fields, analyzer, searchBoost);
    }

    public static Query getQuery(String field, String value, String lang) throws ParseException {
        Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getAnalyzer(lang);
        QueryParser queryParser = new QueryParser(field, analyzer);
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        queryParser.setAllowLeadingWildcard(true);
        queryParser.setSplitOnWhitespace(true);
        if ("zh".equals(lang)) {
            queryParser.setAutoGeneratePhraseQueries(false);
        }
        if ("en".equals(lang)) {
            queryParser.setAutoGeneratePhraseQueries(true);
        }
        queryParser.setPhraseSlop(0);
        return queryParser.parse(value);
    }

    public static Query getTermQuery(String field, String value) {
        Query query = null;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{field, value})) {
            return query;
        }
        return new TermQuery(new Term(field, value));
    }
}

