/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.lucene.search.util;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.Token;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.TokenGroup;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.tartarus.snowball.ext.PorterStemmer;

public class SearchUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SearchUtils.class);
    private static final String DELETE_QUERY_SPECIAL_CHAR_REG = "[`!@:#$%_\\^&=|{}';'\\[\\]<>/\uff01@#\uffe5\u2026\u2026&()\uff08\uff09|\u3010\u3011\u2265\u2018\uff1b\uff1a\"\u201d\u201c\u2019,\uff0c+\u00b7.\u3002\u300a\u300b\u3001~*?\uff1f\u0001]";
    private static final String QUERY_WILDCARD_CHAR_REG = "[\\-\\+\\*\\?\\~:\"]";
    private static final String SPACE_MORE_ONE_REG = "\\s{1,}";
    private static final String QUERY_SIGN_MIMUS = "-";
    private static final String QUERY_SIGN_PLUS = "+";
    private static final String QUERY_SIGN_TILDE = "~";
    private static final String EN_DOUBLE_QUOTES = "\"";
    private static final String ZH_LEFT_DOUBLE_QUOTES = "\u201c";
    private static final String ZH_RIGHT_DOUBLE_QUOTES = "\u201d";
    private static final String STAR_ROOT_CHAR = "*";
    private static final String EN_QUESTION_MARK = "?";
    private static final int NOT_EXIST_INDEX = -1;
    private static final String[] AND_OR = new String[]{"and", "or"};
    private static final char DBC_CHAR_START = ' ';
    private static final char SBC_SPACE = '\u3000';
    private static final char SBC_CHAR_START = '\uff00';
    private static final char SBC_CHAR_END = '\uff5f';
    private static final int CONVERT_STEP = 65248;
    private static final int MAX_CHARS_GET_TOKENS = 5150;
    private static final String HIGHLIGHT_TAG = "span";
    private static final Pattern ENGLISHPATTERN = Pattern.compile("[a-zA-Z]+");
    private static final Pattern WILDCARDPATTERN = Pattern.compile("[~?*]");
    private static final Pattern CONNECTPATTERN = Pattern.compile("[._%]");
    private static final Pattern PARSEPATTERN = Pattern.compile("[!^{}\\[\\]/()]");
    private static final Pattern FIELDPATTERN = Pattern.compile("[:]");
    private static final Pattern TERMPATTERN = Pattern.compile("[\"]");

    private SearchUtils() {
    }

    public static String preHandleSearchField(List<SearchField> searchFieldList, String queryString) {
        String singleField = "";
        if (CollectionUtils.isEmpty(searchFieldList)) {
            return singleField;
        }
        for (SearchField searchField2 : searchFieldList) {
            int pos = queryString.indexOf(searchField2.getFieldName() + ":");
            if (pos == -1) continue;
            singleField = searchField2.getFieldName();
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)singleField)) {
            String finalFieldName = singleField;
            searchFieldList.forEach(searchField -> searchField.setUsed(StringUtils.equals((CharSequence)searchField.getFieldName(), (CharSequence)finalFieldName)));
        }
        return singleField;
    }

    public static String sbcToDbc(String sbc) {
        char[] arrChar = sbc.toCharArray();
        for (int index = 0; index < arrChar.length; ++index) {
            if (arrChar[index] == '\u3000') {
                arrChar[index] = 32;
                continue;
            }
            if (arrChar[index] <= '\uff00' || arrChar[index] >= '\uff5f') continue;
            arrChar[index] = (char)(arrChar[index] - 65248);
        }
        return new String(arrChar);
    }

    public static String newHandleSpecial(String queryKey) {
        String tempQueryKey = queryKey.trim();
        tempQueryKey = StringEscapeUtils.unescapeXml((String)tempQueryKey);
        return SearchUtils.handleTempQueryKey(tempQueryKey);
    }

    private static String handleTempQueryKey(String tempQueryKey) {
        String[] splits = tempQueryKey.split("\\s+");
        ArrayList<String> queryKeys = new ArrayList<String>();
        boolean isHandle = true;
        for (String query : splits) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)query, (CharSequence[])AND_OR)) {
                isHandle = false;
            }
            queryKeys.add(isHandle ? SearchUtils.handleSearchSign(query) : query);
        }
        tempQueryKey = StringUtils.join((Object[])queryKeys.toArray(new String[queryKeys.size()]), (String)" ");
        return tempQueryKey.toLowerCase(Locale.ENGLISH);
    }

    public static String getReplaceAllSpecialChar(String keyword) {
        return SearchUtils.regReplace(keyword, DELETE_QUERY_SPECIAL_CHAR_REG).replaceAll(" ", "");
    }

    public static String ignoreSpecialChar(String queryKey) {
        String tempQueryKey = queryKey.trim();
        if (StringUtils.isBlank((CharSequence)tempQueryKey)) {
            return tempQueryKey;
        }
        if (tempQueryKey.endsWith(".")) {
            tempQueryKey = tempQueryKey.substring(0, tempQueryKey.length() - 1);
        }
        if (tempQueryKey.startsWith(ZH_LEFT_DOUBLE_QUOTES) && tempQueryKey.endsWith(ZH_RIGHT_DOUBLE_QUOTES)) {
            tempQueryKey = tempQueryKey.replaceAll(ZH_LEFT_DOUBLE_QUOTES, EN_DOUBLE_QUOTES);
            tempQueryKey = tempQueryKey.replaceAll(ZH_RIGHT_DOUBLE_QUOTES, EN_DOUBLE_QUOTES);
        }
        if (SearchUtils.isTermQuery(tempQueryKey)) {
            return tempQueryKey;
        }
        tempQueryKey = StringEscapeUtils.unescapeXml((String)tempQueryKey);
        tempQueryKey = SearchUtils.regReplace(tempQueryKey, DELETE_QUERY_SPECIAL_CHAR_REG);
        return SearchUtils.handleTempQueryKey(tempQueryKey);
    }

    public static boolean isTermQuery(String searchKey) {
        boolean enTerm = StringUtils.startsWith((CharSequence)searchKey, (CharSequence)EN_DOUBLE_QUOTES) && StringUtils.endsWith((CharSequence)searchKey, (CharSequence)EN_DOUBLE_QUOTES);
        boolean zhTerm = StringUtils.startsWith((CharSequence)searchKey, (CharSequence)ZH_LEFT_DOUBLE_QUOTES) && StringUtils.endsWith((CharSequence)searchKey, (CharSequence)ZH_RIGHT_DOUBLE_QUOTES);
        return enTerm || zhTerm;
    }

    public static String getTempChar(String lang) {
        return StringUtils.equals((CharSequence)"zh", (CharSequence)lang) ? "," : " ";
    }

    public static String supportWildcard(List<String> terms, String lang) {
        if (CollectionUtils.isEmpty(terms)) {
            return "";
        }
        PorterStemmer porterStemmer = new PorterStemmer();
        StringBuilder resultBuilder = new StringBuilder();
        Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getAnalyzer(lang);
        for (String term : terms) {
            if (SimpleAnalyzerFactory.getInstance().isStopWord(analyzer, term)) {
                resultBuilder.append(term);
                continue;
            }
            if (StringUtils.endsWithAny((CharSequence)term, (CharSequence[])new CharSequence[]{STAR_ROOT_CHAR, EN_QUESTION_MARK, QUERY_SIGN_TILDE}) || StringUtils.equalsAny((CharSequence)term, (CharSequence[])new CharSequence[]{"and", "or", "not"})) {
                resultBuilder.append(term);
                continue;
            }
            resultBuilder.append(SearchUtils.getTermWithPoster(porterStemmer, term));
        }
        SimpleAnalyzerFactory.closeAnalyzer(analyzer);
        return resultBuilder.toString();
    }

    private static String getTermWithPoster(PorterStemmer porterStemmer, String content) {
        String tempItem = content;
        String startSign = "";
        if (StringUtils.startsWithAny((CharSequence)tempItem, (CharSequence[])new CharSequence[]{QUERY_SIGN_MIMUS, QUERY_SIGN_PLUS})) {
            startSign = tempItem.substring(0, 1);
            tempItem = tempItem.substring(1);
        }
        if (SearchUtils.isEnglish(tempItem) && tempItem.length() > 1) {
            porterStemmer.setCurrent(tempItem);
            porterStemmer.stem();
            String poster = porterStemmer.getCurrent();
            if (!StringUtils.equals((CharSequence)tempItem, (CharSequence)poster)) {
                if (StringUtils.startsWithAny((CharSequence)tempItem, (CharSequence[])new CharSequence[]{poster})) {
                    tempItem = startSign + poster + STAR_ROOT_CHAR;
                }
            } else {
                tempItem = startSign + poster + STAR_ROOT_CHAR;
            }
        } else {
            tempItem = content;
        }
        return tempItem;
    }

    private static String handleSearchSign(String queryKey) {
        String query = queryKey;
        if (StringUtils.isBlank((CharSequence)(query = SearchUtils.regReplace(query, QUERY_WILDCARD_CHAR_REG)))) {
            return query;
        }
        query = queryKey;
        if (StringUtils.startsWith((CharSequence)query, (CharSequence)QUERY_SIGN_PLUS)) {
            query = SearchUtils.replacePlusMultiChar(query);
            query = query.replaceAll(SPACE_MORE_ONE_REG, " +").trim();
        }
        if (StringUtils.startsWith((CharSequence)query, (CharSequence)QUERY_SIGN_MIMUS)) {
            query = SearchUtils.replacePlusMultiChar(query).trim();
            query = QUERY_SIGN_MIMUS + query.replaceAll(SPACE_MORE_ONE_REG, " -").trim();
        }
        if (StringUtils.endsWith((CharSequence)query, (CharSequence)QUERY_SIGN_TILDE)) {
            query = SearchUtils.replacePlusMultiChar(query).trim();
            query = query.replaceAll(SPACE_MORE_ONE_REG, "~ ").trim() + QUERY_SIGN_TILDE;
        }
        return query;
    }

    public static String regReplace(String queryKey, String reg) {
        String tempQueryKey = queryKey;
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(tempQueryKey);
        tempQueryKey = matcher.replaceAll(" ");
        return tempQueryKey.replaceAll("\\\\", "").trim();
    }

    private static String replacePlusMultiChar(String query) {
        return query.replaceAll(QUERY_SIGN_MIMUS, " ").replaceAll("\\+", " ").replaceAll(QUERY_SIGN_TILDE, " ").replaceAll(SPACE_MORE_ONE_REG, " ").trim();
    }

    public static String fieldConvert(String searchKey) {
        if (StringUtils.isBlank((CharSequence)searchKey)) {
            return "";
        }
        return searchKey.replaceFirst("title:", "t_title:").replaceFirst("contents:", "t_content:").replaceFirst("keyword:", "tp_keywords:");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getTokens(Query query, String lang, String field, String value) {
        QueryScorer fragmentScorer = SearchUtils.getFragmentScorer(query);
        ArrayList<Token> tokenItems = new ArrayList<Token>();
        try (Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getHighLightAnalyzer(lang);
             TokenStream tokenStream = analyzer.tokenStream(field, value);
             TokenStream newStream = fragmentScorer.init(tokenStream);){
            if (newStream == null) {
                Set set = SetUtils.emptySet();
                return set;
            }
            TokenGroup tokenGroup = new TokenGroup(newStream);
            newStream.reset();
            OffsetAttribute offsetAtt = (OffsetAttribute)newStream.addAttribute(OffsetAttribute.class);
            while (newStream.incrementToken()) {
                SearchUtils.validateAndAddToken(offsetAtt, value, tokenGroup, tokenItems, fragmentScorer);
            }
            if (tokenGroup.getNumTokens() > 0 && Float.compare(tokenGroup.getTotalScore(), 0.0f) > 0) {
                tokenItems.add(SearchUtils.getToken(tokenGroup, value));
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get tokens error.", (Throwable)e);
        }
        if (!CollectionUtils.isEmpty(tokenItems)) return tokenItems.stream().map(Token::getValue).collect(Collectors.toSet());
        return new HashSet<String>();
    }

    private static void validateAndAddToken(OffsetAttribute offsetAtt, String value, TokenGroup tokenGroup, List<Token> tokenItems, QueryScorer fragmentScorer) {
        if (offsetAtt.startOffset() >= 5150) {
            return;
        }
        if (offsetAtt.endOffset() > value.length() || offsetAtt.startOffset() > value.length()) {
            return;
        }
        if (tokenGroup.getNumTokens() <= 0 || !tokenGroup.isDistinct()) {
            tokenGroup.addToken(fragmentScorer.getTokenScore());
            return;
        }
        if (Float.compare(tokenGroup.getTotalScore(), 0.0f) > 0) {
            tokenItems.add(SearchUtils.getToken(tokenGroup, value));
        }
        tokenGroup.clear();
        tokenGroup.addToken(fragmentScorer.getTokenScore());
    }

    private static Token getToken(TokenGroup tokenGroup, String value) {
        String subValue = value.substring(tokenGroup.getStartOffset(), tokenGroup.getEndOffset()).toLowerCase(Locale.ENGLISH);
        return new Token(subValue, tokenGroup.getStartOffset(), tokenGroup.getEndOffset());
    }

    private static QueryScorer getFragmentScorer(Query query) {
        QueryScorer fragmentScorer = new QueryScorer(query);
        fragmentScorer.setMaxDocCharsToAnalyze(5150);
        ArrayList<TextFragment> docFrags = new ArrayList<TextFragment>();
        StringBuilder newText = new StringBuilder();
        TextFragment currentFrag = new TextFragment((CharSequence)newText, newText.length(), docFrags.size());
        fragmentScorer.startFragment(currentFrag);
        docFrags.add(currentFrag);
        return fragmentScorer;
    }

    public static boolean isEnglish(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        Matcher matcher = ENGLISHPATTERN.matcher(text);
        return matcher.matches();
    }

    public static String keyWordReplace(String text, String tempChar) {
        String result = text;
        Matcher matcher = WILDCARDPATTERN.matcher(result);
        return matcher.replaceAll(tempChar);
    }

    public static String connectCharReplace(String text) {
        String result = text;
        Matcher matcher = CONNECTPATTERN.matcher(result);
        return matcher.replaceAll(" ");
    }

    public static String excludeSpecialChar(String keyword, String lang) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{keyword, lang})) {
            return "";
        }
        String result = keyword;
        Matcher matcher = PARSEPATTERN.matcher(result);
        result = matcher.replaceAll(SearchUtils.getTempChar(lang));
        return result.replaceAll("\\\\", SearchUtils.getTempChar(lang));
    }

    public static String handleFieldChar(String keyword, String lang) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{keyword, lang})) {
            return "";
        }
        String result = keyword;
        Matcher matcher = FIELDPATTERN.matcher(result);
        return matcher.replaceAll(SearchUtils.getTempChar(lang));
    }

    public static String handleTermChar(String keyword, String lang) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{keyword, lang})) {
            return "";
        }
        String result = keyword;
        Matcher matcher = TERMPATTERN.matcher(result);
        return matcher.replaceAll(SearchUtils.getTempChar(lang));
    }

    public static Set<String> getKeywords(String highlightText) {
        Document parseDoc = Jsoup.parse((String)highlightText);
        Elements elements = parseDoc.select(HIGHLIGHT_TAG);
        HashSet<String> keywords = new HashSet<String>();
        for (Element element : elements) {
            keywords.add(element.ownText().toLowerCase(Locale.ENGLISH));
        }
        return keywords;
    }

    public static Set<String> getIndexDirs(String path, int cpuNums) {
        String canonicalPath;
        HashSet<String> subIndexDirs = new HashSet<String>();
        for (int i = 0; i < cpuNums; ++i) {
            String subIndexDir = SearchUtils.getPath(path + File.separator + "index" + i);
            if (!StringUtils.isNotBlank((CharSequence)subIndexDir)) continue;
            subIndexDirs.add(subIndexDir);
        }
        if (CollectionUtils.isEmpty(subIndexDirs) && StringUtils.isNotBlank((CharSequence)(canonicalPath = SearchUtils.getPath(path)))) {
            subIndexDirs.add(canonicalPath);
        }
        return subIndexDirs;
    }

    private static String getPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        File file = FileUtils.getFile((String[])new String[]{path + File.separator + "write.lock"});
        if (!file.exists()) {
            return "";
        }
        try {
            return FileUtils.getFile((String[])new String[]{path}).getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Valid illegal index path error:{0}", (Throwable)e, new Object[]{file.getName()});
            return "";
        }
    }
}

