/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.search.component;

import com.huawei.support.icscbb.commonsearch.lucene.config.HdxMetaConfig;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchDocDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPoolFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.HighlightUtils;
import com.huawei.support.icscbb.commonsearch.search.entity.HdxMetaDo;
import com.huawei.support.icscbb.commonsearch.search.entity.HdxPageInfo;
import com.huawei.support.icscbb.commonsearch.search.entity.HdxSearchResult;
import com.huawei.support.icscbb.commonsearch.search.entity.HdxSearchTopicDo;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.search.manager.factory.SearchManagerFactory;
import com.huawei.support.icscbb.commonsearch.search.query.QueryFactory;
import com.huawei.support.icscbb.commonsearch.search.util.HwicsSearchUtils;
import com.huawei.wsf.core.HWEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;

public class SearchProcessor {
    private static final int DEFAULT_PAGE_SIZE = 15;

    private SearchProcessor() {
    }

    public static SearchResult search(ParamBase base, List<String> indexDirs, String taskType) throws SearchException, ParseException {
        return SearchManagerFactory.getSearchManager(taskType).getSearchResult(base, QueryFactory.buildQuery(taskType), indexDirs);
    }

    public static HdxSearchResult searchHdxDoc(ParamBase base, List<String> indexDirs, String taskType) throws SearchException, ParseException {
        SearchResult searchResult = SearchProcessor.search(base, indexDirs, taskType);
        if (searchResult == null) {
            return null;
        }
        return SearchProcessor.convert(base, searchResult);
    }

    public static int getResultCount(ParamBase searchParam, Collection<String> indexDirs, String taskType) throws SearchException {
        LibSearchParam libSearchParam = null;
        if (searchParam instanceof LibSearchParam) {
            libSearchParam = (LibSearchParam)searchParam;
            HwicsSearchUtils.preHandleSearchKey(libSearchParam);
        }
        if (libSearchParam == null || StringUtils.isBlank((CharSequence)libSearchParam.getSearchText())) {
            return 0;
        }
        return SearchManagerFactory.getSearchManager(taskType).count(libSearchParam, QueryFactory.buildQuery(null), indexDirs);
    }

    private static HdxSearchResult convert(ParamBase paramBase, SearchResult searchResult) {
        List<SearchDocDto> searchDocDtos = searchResult.getResultSet();
        if (CollectionUtils.isEmpty(searchDocDtos)) {
            return null;
        }
        LibSearchParam libSearchParam = null;
        if (paramBase instanceof LibSearchParam) {
            libSearchParam = (LibSearchParam)paramBase;
        }
        if (libSearchParam == null) {
            return null;
        }
        Collection<String> bigTypes = HdxMetaConfig.INSTANCE.getBigTypeNames();
        HdxSearchResult hdxSearchResult = new HdxSearchResult(new HdxPageInfo(searchResult.getTotal(), SearchProcessor.countTotalPage(searchResult.getTotal(), libSearchParam.getPageSize()), libSearchParam.getPageIndex(), libSearchParam.getPageSize()));
        for (SearchDocDto searchDocDto : searchDocDtos) {
            HdxSearchTopicDo hdxSearchTopicDo = new HdxSearchTopicDo.Builder().setDocId(searchDocDto.getField("docId")).setContents(HighlightUtils.encodeHighLightPieces(searchDocDto.getField("t_content"), paramBase.getLang())).setSummary(HighlightUtils.encodeHighLightPieces(searchDocDto.getField("summary"), paramBase.getLang())).setTitle(HighlightUtils.encodeHighLightPieces(searchDocDto.getField("t_title"), paramBase.getLang())).setTopicId(searchDocDto.getField("topicid")).setTopicPath(HWEncoder.encodeForHTML((String)searchDocDto.getField("navipath"))).setTopicUrl(searchDocDto.getField("topicurl")).setKeywords(searchDocDto.getKeywords()).setLibId(searchDocDto.getField("libId")).setLibVer(searchDocDto.getField("libVer")).setLibName(searchDocDto.getField("libName")).setIssuedate(searchDocDto.getField("issueDate")).setProductName(searchDocDto.getField("productName")).setProductV(searchDocDto.getField("productV")).setLang(searchDocDto.getField("lang")).setScore(searchDocDto.getScore()).build();
            Set<String> fieldNames = searchDocDto.getFieldNames();
            for (String fieldName : fieldNames) {
                if (!bigTypes.contains(fieldName)) continue;
                hdxSearchTopicDo.addHdxMetaDoToList(new HdxMetaDo(fieldName, searchDocDto.getField(fieldName)));
            }
            hdxSearchResult.addResult(hdxSearchTopicDo);
            hdxSearchResult.setSearchInput(libSearchParam.getSearchText());
        }
        return hdxSearchResult;
    }

    private static int countTotalPage(int total, int pageSize) {
        int pageSizeTemp = pageSize;
        if (pageSizeTemp <= 0) {
            pageSizeTemp = 15;
        }
        int totalPage = total / pageSizeTemp;
        return total % pageSizeTemp == 0 ? totalPage : totalPage + 1;
    }

    public static boolean deleteIndexReaderCache(String path, String taskType) {
        return SearcherPoolFactory.getInstance().deleteCache(path, taskType);
    }
}

