/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.search.manager;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchDocDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.highlight.CommonHighlighter;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPool;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPoolFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.PhraseQueryUtils;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.SearchUtils;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.search.util.HwicsSearchUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class LibSearchManager
extends SearchManagerBase {
    private static final int KEYWORDS_MAX_NUM = 30;
    private static final int ARRAY_DEFAULT_SIZE = 50;
    private static final String HIGHLIGHT_FIELD_NAME = "t_highlight";

    @Override
    protected SearcherPool getSearchPool(ParamBase paramBase) {
        return SearcherPoolFactory.getInstance().getPool("libtasktype", paramBase.getPoolSize(), paramBase.getExpireTime());
    }

    @Override
    protected void preProcess(ParamBase paramBase) {
        if (paramBase instanceof LibSearchParam) {
            LibSearchParam searchParam = (LibSearchParam)paramBase;
            HwicsSearchUtils.preHandleSearchKey(searchParam);
        }
    }

    @Override
    protected SearchResult parseHits(IndexSearcher searcher, TopDocs hits, int count, ParamBase paramBase) throws SearchException, ParseException {
        int end;
        int firstPageSize;
        int pageSize;
        LibSearchParam libSearchParam = null;
        if (paramBase instanceof LibSearchParam) {
            libSearchParam = (LibSearchParam)paramBase;
        }
        SearchResult searchResult = new SearchResult(count);
        if (hits == null || hits.totalHits.value == 0L || libSearchParam == null) {
            return searchResult;
        }
        int pageIndex = libSearchParam.getPageIndex();
        int start = this.getPageStart(pageIndex, pageSize = libSearchParam.getPageSize(), firstPageSize = libSearchParam.getFirstPageSize());
        if (start > (end = this.getPageEnd(pageIndex, pageSize, count, firstPageSize))) {
            return searchResult;
        }
        Query highlightQuery = this.getHighlightQuery(libSearchParam);
        ScoreDoc[] scoreDocs = hits.scoreDocs;
        for (int index = start; index < end; ++index) {
            try {
                Document doc = searcher.doc(scoreDocs[index].doc);
                SearchDocDto searchDoc = this.parseDocument(doc, libSearchParam, highlightQuery);
                searchDoc.setScore(scoreDocs[index].score);
                searchResult.addResult(searchDoc);
                continue;
            }
            catch (IOException e) {
                throw new SearchException("ParseHits occur error.", e);
            }
        }
        return searchResult;
    }

    private Query getHighlightQuery(LibSearchParam libSearchParam) throws ParseException {
        return PhraseQueryUtils.getQuery(HIGHLIGHT_FIELD_NAME, libSearchParam.getSearchText(), libSearchParam.getLang());
    }

    private SearchDocDto parseDocument(Document doc, LibSearchParam libSearchParam, Query highlightQuery) {
        Set<String> highLightFields = this.getHighLightField(libSearchParam);
        SearchDocDto searchDoc = new SearchDocDto();
        List fields = doc.getFields();
        HashSet<String> keywords = new HashSet<String>(50);
        String lang = libSearchParam.getLang();
        CommonHighlighter commonHighlighter = new CommonHighlighter(highlightQuery, lang);
        for (IndexableField field : fields) {
            String name = field.name();
            String[] values = doc.getValues(name);
            if (!highLightFields.contains(name)) {
                searchDoc.addField(name, values);
                continue;
            }
            String[] highlightValues = new String[values.length];
            int index = 0;
            for (String value : values) {
                String highLightText = commonHighlighter.highlight(HIGHLIGHT_FIELD_NAME, value, libSearchParam.getMaxNumFragments());
                highlightValues[index++] = highLightText;
                Set<String> subKeywords = SearchUtils.getKeywords(highLightText);
                keywords.addAll(subKeywords);
            }
            searchDoc.addField(name, highlightValues);
        }
        Set<String> keywordsSorts = this.keywordsSort(keywords);
        if (CollectionUtils.isEmpty(keywordsSorts)) {
            keywordsSorts.add(libSearchParam.getSearchText());
        }
        if (keywordsSorts.size() > 30) {
            searchDoc.setKeywords(JSON.toJSONString(this.subSet(keywordsSorts)));
        } else {
            searchDoc.setKeywords(JSON.toJSONString(keywordsSorts));
        }
        return searchDoc;
    }

    private Set<String> getHighLightField(LibSearchParam libSearchParam) {
        List<SearchField> highLightFields = libSearchParam.getAllSearchFields();
        HashSet<String> highLightFieldSet = new HashSet<String>();
        highLightFields.forEach(searchField -> {
            if (searchField.isHighLight()) {
                highLightFieldSet.add(searchField.getFieldName());
            }
        });
        return highLightFieldSet;
    }
}

