/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.search.manager;

import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchDocDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPool;
import com.huawei.support.icscbb.commonsearch.lucene.search.pool.SearcherPoolFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.search.entity.TripleSearchParam;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class TripleSearchManager
extends SearchManagerBase {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(TripleSearchManager.class);

    @Override
    protected SearcherPool getSearchPool(ParamBase paramBase) {
        return SearcherPoolFactory.getInstance().getPool("tripletasktype", paramBase.getPoolSize(), paramBase.getExpireTime());
    }

    @Override
    protected SearchResult parseHits(IndexSearcher searcher, TopDocs hits, int count, ParamBase paramBase) throws SearchException, ParseException {
        TripleSearchParam tripleSearchParam = null;
        if (paramBase instanceof TripleSearchParam) {
            tripleSearchParam = (TripleSearchParam)paramBase;
        }
        if (hits == null || hits.totalHits.value == 0L || tripleSearchParam == null) {
            return null;
        }
        SearchResult searchResult = new SearchResult(count);
        ScoreDoc[] scoreDocs = hits.scoreDocs;
        try {
            Document doc = searcher.doc(scoreDocs[0].doc);
            String tail = doc.get("tail");
            SearchDocDto searchDocDto = new SearchDocDto();
            searchDocDto.setKeywords(tail);
            searchResult.addResult(searchDocDto);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ParseHits occur error.", (Throwable)e);
        }
        return searchResult;
    }
}

