/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.search.query;

import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.PhraseQueryUtils;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class LibQuery
implements QueryBase {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibQuery.class);
    private static final Pattern DIGITS_OR_LETTERS = Pattern.compile("[?*0-9a-zA-Z]+");

    @Override
    public Query create(ParamBase param) {
        LibSearchParam libSearchParam = null;
        if (param instanceof LibSearchParam) {
            libSearchParam = (LibSearchParam)param;
        }
        if (libSearchParam == null || StringUtils.isBlank((CharSequence)libSearchParam.getSearchText())) {
            return null;
        }
        this.preprocessSearchText(libSearchParam);
        Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getAnalyzer(libSearchParam.getLang());
        Query query = null;
        try {
            BooleanQuery baseQuery = PhraseQueryUtils.getCommonQuery(libSearchParam, libSearchParam.getSearchText());
            Query extraQuery = PhraseQueryUtils.buildExtraQuery(libSearchParam.getExtraConditions(), analyzer, param.getType());
            query = PhraseQueryUtils.attachExtraQuery((Query)baseQuery, extraQuery);
        }
        catch (ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Create query fail.", (Throwable)e);
        }
        return query;
    }

    private void preprocessSearchText(LibSearchParam libSearchParam) {
        String searchText = libSearchParam.getSearchText();
        if ("en".equals(libSearchParam.getLang())) {
            return;
        }
        if (!DIGITS_OR_LETTERS.matcher(searchText).matches()) {
            return;
        }
        if (StringUtils.containsNone((CharSequence)searchText, (char[])new char[]{'?', '*'})) {
            libSearchParam.setSearchText("\"" + searchText + "\"");
            return;
        }
        StringBuilder searchTextBuilder = new StringBuilder();
        int len = searchText.length();
        for (int i = 0; i < len; ++i) {
            searchTextBuilder.append(searchText.charAt(i));
            if (i + 1 >= len) continue;
            char currentChar = searchText.charAt(i);
            char nextChar = searchText.charAt(i + 1);
            if (Character.isDigit(currentChar) && Character.isLetter(nextChar)) {
                searchTextBuilder.append(" ");
            }
            if (!Character.isLetter(currentChar) || !Character.isDigit(nextChar)) continue;
            searchTextBuilder.append(" ");
        }
        libSearchParam.setSearchText(searchTextBuilder.toString());
    }
}

