/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.search.util;

import com.huawei.support.icscbb.commonsearch.lucene.search.convert.StandardConvert;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.SearchUtils;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;

public class HwicsSearchUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HwicsSearchUtils.class);
    private static final String ADVANCED_SEARCH_KEYWORD_SEPARATOR = "&&&";
    private static final List<String> stopwords = new ArrayList<String>();
    private static final String DOUBLEQUOTES = "\"";

    private HwicsSearchUtils() {
    }

    public static void preHandleSearchKey(LibSearchParam libSearchParam) {
        String searchKey;
        if (libSearchParam == null) {
            return;
        }
        String lang = libSearchParam.getLang();
        if (StringUtils.isBlank((CharSequence)lang)) {
            libSearchParam.setLang("zh");
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = HwicsSearchUtils.preHandleSearchField(libSearchParam)))) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = StringUtils.contains((CharSequence)searchKey, (CharSequence)ADVANCED_SEARCH_KEYWORD_SEPARATOR) ? HwicsSearchUtils.getAdvancedSearchKeyword(searchKey, lang) : HwicsSearchUtils.preHandleSearchKey(searchKey, lang)))) {
            libSearchParam.setSearchText(searchKey);
            return;
        }
        HwicsSearchUtils.preHandleNotTerm(searchKey, libSearchParam);
    }

    private static String preHandleSearchField(LibSearchParam libSearchParam) {
        String searchKey = libSearchParam.getSearchText();
        searchKey = SearchUtils.sbcToDbc(searchKey);
        searchKey = SearchUtils.fieldConvert(searchKey);
        String searchField = SearchUtils.preHandleSearchField(libSearchParam.getAllSearchFields(), searchKey);
        if (StringUtils.isNotBlank((CharSequence)searchField)) {
            searchKey = searchKey.substring(searchField.length() + 1);
        }
        return searchKey;
    }

    private static String getAdvancedSearchKeyword(String searchKey, String lang) {
        String[] keywords = searchKey.split(ADVANCED_SEARCH_KEYWORD_SEPARATOR);
        List resultList = Arrays.stream(keywords).map(keyword -> {
            String newKeyword = HwicsSearchUtils.preHandleSearchKey(keyword, lang);
            return StringUtils.isBlank((CharSequence)newKeyword) ? "" : "(" + newKeyword + ")";
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return CollectionUtils.isEmpty(resultList) ? "" : String.join((CharSequence)" AND ", resultList);
    }

    private static String preHandleSearchKey(String keyword, String lang) {
        String searchTemp = keyword;
        String replaceKeyword = SearchUtils.getReplaceAllSpecialChar(searchTemp);
        if (StringUtils.isBlank((CharSequence)replaceKeyword)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "keyword is all special char.");
            return "";
        }
        boolean isTermQuery = SearchUtils.isTermQuery(searchTemp);
        if (isTermQuery) {
            searchTemp = searchTemp.substring(1, searchTemp.length() - 1);
        }
        searchTemp = SearchUtils.handleTermChar(searchTemp, lang);
        if (StringUtils.isBlank((CharSequence)(searchTemp = SearchUtils.excludeSpecialChar(searchTemp, lang))) || HwicsSearchUtils.isOrAllStopword(searchTemp)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Search Text only contain stop word.");
            return "";
        }
        if (isTermQuery) {
            searchTemp = DOUBLEQUOTES + searchTemp + DOUBLEQUOTES;
        }
        return searchTemp;
    }

    public static void preHandleNotTerm(String query, LibSearchParam libSearchParam) {
        String searchTemp = query;
        if (StringUtils.isBlank((CharSequence)(searchTemp = SearchUtils.handleFieldChar(searchTemp, libSearchParam.getLang()))) || HwicsSearchUtils.isOrAllStopword(searchTemp)) {
            libSearchParam.setSearchText("");
            CodeCCUtils.INSTANCE.warnLog(LOG, "Search Text is empty after preHandle.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)(searchTemp = SearchUtils.newHandleSpecial(searchTemp)))) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Search Text is empty after preHandle.");
            libSearchParam.setSearchText("");
            return;
        }
        String searchText = new StandardConvert().preProcessField(searchTemp).trim();
        libSearchParam.setSearchText(searchText);
    }

    private static boolean isOrAllStopword(String searchText) {
        String[] splits;
        for (String item : splits = StringUtils.split((String)StringUtils.trim((String)searchText), (String)" ")) {
            String split = item.toLowerCase(Locale.ENGLISH);
            if (stopwords.contains(split)) continue;
            return false;
        }
        return true;
    }

    static {
        stopwords.addAll(Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"));
        SmartChineseAnalyzer.getDefaultStopSet().forEach(e -> stopwords.add(e.toString()));
    }
}

