/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.searchdb.dao;

import com.huawei.support.icscbb.commonsearch.searchdb.mapper.GlobalIndexMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public class GlobalIndexDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(GlobalIndexDaoHandler.class);

    private GlobalIndexDaoHandler() {
    }

    public static GlobalIndexDaoHandler getInstance() {
        return GlobalIndexDaoHandlerHolder.INSTANCE;
    }

    public int selectNumOfFinished(GlobalIndexMapper globalIndexMapper) {
        int numOfFinished = 0;
        try {
            numOfFinished = globalIndexMapper.selectNumOfFinished();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]select DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectNumOfFinished error.", (Throwable)e);
        }
        return numOfFinished;
    }

    public int selectTotal(GlobalIndexMapper globalIndexMapper) {
        int total = 0;
        try {
            total = globalIndexMapper.selectTotal();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]select DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectTotal error.", (Throwable)e);
        }
        return total;
    }

    public List<String> selectIndexDirs(GlobalIndexMapper globalIndexMapper) {
        ArrayList<String> indexDirs = new ArrayList();
        try {
            indexDirs = globalIndexMapper.selectIndexDirs();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]select DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectIndexDirs error.", (Throwable)e);
        }
        return indexDirs;
    }

    private static class GlobalIndexDaoHandlerHolder {
        private static final GlobalIndexDaoHandler INSTANCE = new GlobalIndexDaoHandler();

        private GlobalIndexDaoHandlerHolder() {
        }
    }
}

