/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.searchdb.dao;

import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.mapper.HdxIndexMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class HdxIndexDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexDaoHandler.class);
    private static final String ERROR_MESSAGE = "[hdx-index]DataIntegrityViolationException.";

    private HdxIndexDaoHandler() {
    }

    public static HdxIndexDaoHandler getInstance() {
        return HdxIndexDaoHandlerHolder.INSTANCE;
    }

    public void createIndexTb(HdxIndexMapper hdxIndexMapper) {
        try {
            hdxIndexMapper.createIndexTb();
            hdxIndexMapper.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "[hdx-index]table INDEX_TABLE is already exist or create error.", e);
        }
    }

    public int addIndex(HdxIndexMapper hdxIndexMapper, HdxIndexDo hdxIndexDo) {
        int result = 0;
        if (hdxIndexDo == null) {
            return result;
        }
        try {
            result = hdxIndexMapper.addIndex(hdxIndexDo);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]addIndex error.", (Throwable)e);
        }
        return result;
    }

    public boolean addBatchIndex(HdxIndexMapper hdxIndexMapper, List<HdxIndexDo> hdxIndexDos) {
        try {
            hdxIndexMapper.addBatchIndex(hdxIndexDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HdxIndexMapper addBatchIndex Error", e);
            return false;
        }
        return true;
    }

    public HdxIndexDo selectIndex(HdxIndexMapper hdxIndexMapper, String docId) {
        HdxIndexDo hdxIndexDo = null;
        try {
            hdxIndexDo = hdxIndexMapper.selectIndex(docId);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]selectIndex error.", (Throwable)e);
        }
        return hdxIndexDo;
    }

    public List<HdxIndexDo> selectAllIndex(HdxIndexMapper hdxIndexMapper) {
        ArrayList<HdxIndexDo> hdxIndexDos = new ArrayList();
        try {
            hdxIndexDos = hdxIndexMapper.selectAllIndex();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]selectAllIndex error.", (Throwable)e);
        }
        return hdxIndexDos;
    }

    public int deleteIndex(HdxIndexMapper hdxIndexMapper, String docId) {
        int result = 0;
        try {
            result = hdxIndexMapper.deleteIndex(docId);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]deleteIndex error.", (Throwable)e);
        }
        return result;
    }

    public int deleteAll(HdxIndexMapper hdxIndexMapper) {
        int result = 0;
        try {
            result = hdxIndexMapper.deleteAll();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]deleteAll error.", (Throwable)e);
        }
        return result;
    }

    public int updateIndex(HdxIndexMapper hdxIndexMapper, String docId, String status, String errMsg) {
        HashMap<String, Object> updateParams = new HashMap<String, Object>(16);
        updateParams.put("docId", docId);
        updateParams.put("state", status);
        updateParams.put("errMessage", errMsg);
        updateParams.put("createTime", DateUtils.getCurrentDateStr());
        int result = 0;
        try {
            result = hdxIndexMapper.updateIndex(updateParams);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]updateIndex error.", (Throwable)e);
        }
        return result;
    }

    public int updateProcessrate(HdxIndexMapper hdxIndexMapper, String docId, String rate) {
        int number = 0;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, rate})) {
            return number;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("docId", docId);
        params.put("processRate", rate);
        try {
            number = hdxIndexMapper.updateProcessrate(params);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]updateProcessrate error.", (Throwable)e);
        }
        return number;
    }

    public List<String> selectDocIds(HdxIndexMapper hdxIndexMapper, List<String> docIds) {
        ArrayList<String> result = new ArrayList();
        try {
            result = hdxIndexMapper.selectDocIds(docIds);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, ERROR_MESSAGE, (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]selectDocIds error.", (Throwable)e);
        }
        return result;
    }

    public List<String> selectIndexDirByDocId(HdxIndexMapper hdxIndexMapper, List<String> docIds) {
        return hdxIndexMapper.selectIndexDirByDocId(docIds);
    }

    public List<HdxIndexDo> selectByPage(HdxIndexMapper hdxIndexMapper, int start, int len) {
        ArrayList<HdxIndexDo> result = new ArrayList();
        try {
            result = hdxIndexMapper.selectByPage(start, len);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectByPage DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectByPage error.", (Throwable)e);
        }
        return result;
    }

    public int queryTotalNums(HdxIndexMapper hdxIndexMapper) {
        int result = 0;
        try {
            result = hdxIndexMapper.queryTotalNums();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]count DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]count error.", (Throwable)e);
        }
        return result;
    }

    public int update(HdxIndexMapper hdxIndexMapper, HdxIndexDo hdxIndexDo) {
        int number = 0;
        if (hdxIndexDo == null) {
            return number;
        }
        try {
            number = hdxIndexMapper.update(hdxIndexDo);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]update error.", (Throwable)e);
        }
        return number;
    }

    private static class HdxIndexDaoHandlerHolder {
        private static final HdxIndexDaoHandler INSTANCE = new HdxIndexDaoHandler();

        private HdxIndexDaoHandlerHolder() {
        }
    }
}

