/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.searchdb.dao;

import com.huawei.support.icscbb.commonsearch.searchdb.constant.IcsIndexConstants;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.IcsIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.mapper.IcsIndexMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class IcsIndexDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexDaoHandler.class);
    private static final String STR_DOC_ID = "docId";
    private static final String STR_REF_DOC_ID = "refDocId";

    private IcsIndexDaoHandler() {
    }

    public static IcsIndexDaoHandler getInstance() {
        return IcsIndexDaoHandlerHolder.INSTANCE;
    }

    public void createIndexTb(IcsIndexMapper icsIndexMapper) {
        try {
            icsIndexMapper.createIndexTb();
            icsIndexMapper.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "[index]table INDEX_TABLE is already exist or create error.", e);
        }
    }

    public int addIndex(IcsIndexMapper icsIndexMapper, IcsIndexDo icsIndexDo) {
        int result = 0;
        if (icsIndexDo == null) {
            return result;
        }
        try {
            result = icsIndexMapper.addIndex(icsIndexDo);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]addIndex DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]addIndex error.", (Throwable)e);
        }
        return result;
    }

    public boolean addBatchIndex(IcsIndexMapper icsIndexMapper, List<IcsIndexDo> icsIndexDos) {
        try {
            icsIndexMapper.addBatchIndex(icsIndexDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsIndexMapper addBatchIndex Error", e);
            return false;
        }
        return true;
    }

    public int addIndexRef(IcsIndexMapper icsIndexMapper, IcsIndexDo icsIndexDo, Set<String> refDocIds) {
        AtomicInteger atomicInteger = new AtomicInteger();
        if (icsIndexDo == null) {
            return atomicInteger.get();
        }
        if (CollectionUtils.isEmpty(refDocIds)) {
            return atomicInteger.get();
        }
        for (String refDocId : refDocIds) {
            if (StringUtils.equals((CharSequence)icsIndexDo.getDocId(), (CharSequence)refDocId)) continue;
            this.addIndexRef(icsIndexMapper, icsIndexDo, refDocId, atomicInteger);
        }
        return atomicInteger.get();
    }

    private void addIndexRef(IcsIndexMapper icsIndexMapper, IcsIndexDo icsIndexDo, String refDocId, AtomicInteger atomicInteger) {
        IcsIndexDo refIcsIndexDo = this.selectRef(icsIndexMapper, icsIndexDo.getDocId(), refDocId);
        if (refIcsIndexDo == null) {
            IcsIndexDo newIcsIndexDo = new IcsIndexDo();
            BeanUtils.copyProperties((Object)icsIndexDo, (Object)newIcsIndexDo);
            newIcsIndexDo.setRefDocId(refDocId);
            String indexDir = String.format(Locale.ENGLISH, IcsIndexConstants.HDX_INDEXDIR_FORMAT, icsIndexDo.getDocId(), "", refDocId);
            newIcsIndexDo.setIndexDir(indexDir);
            atomicInteger.addAndGet(this.addIndex(icsIndexMapper, newIcsIndexDo));
        }
    }

    public List<IcsIndexDo> select(IcsIndexMapper icsIndexMapper, String docId) {
        ArrayList<IcsIndexDo> icsIndexDos = new ArrayList();
        try {
            icsIndexDos = icsIndexMapper.selectIndex(docId);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]select DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectIndex error.", (Throwable)e);
        }
        return icsIndexDos;
    }

    public IcsIndexDo selectRef(IcsIndexMapper icsIndexMapper, String docId, String refDocId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(STR_DOC_ID, docId);
        params.put(STR_REF_DOC_ID, refDocId);
        IcsIndexDo hdxIndexDto = null;
        try {
            hdxIndexDto = icsIndexMapper.selectMainLibIndex(params);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectRef DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectRef error.", (Throwable)e);
        }
        return hdxIndexDto;
    }

    public List<String> selectAllIndex(IcsIndexMapper icsIndexMapper) {
        ArrayList<String> icsIndexDos = new ArrayList();
        try {
            icsIndexDos = icsIndexMapper.selectAllIndex();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectAllIndex DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectAllIndex error.", (Throwable)e);
        }
        return icsIndexDos;
    }

    public int deleteIndex(IcsIndexMapper icsIndexMapper, String docId) {
        int result = 0;
        try {
            result = icsIndexMapper.deleteIndex(docId);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteIndex DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteIndex error.", (Throwable)e);
        }
        return result;
    }

    public int deleteAll(IcsIndexMapper icsIndexMapper) {
        int result = 0;
        try {
            result = icsIndexMapper.deleteAll();
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteAll DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteAll error.", (Throwable)e);
        }
        return result;
    }

    public int deleteRefIndex(IcsIndexMapper icsIndexMapper, String docId, String refDocId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(STR_DOC_ID, docId);
        params.put(STR_REF_DOC_ID, refDocId);
        int result = 0;
        try {
            result = icsIndexMapper.deleteRefIndex(params);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteRefIndex DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]deleteRefIndex error.", (Throwable)e);
        }
        return result;
    }

    public int updateIndex(IcsIndexMapper icsIndexMapper, String docId, String status, String errMsg) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(STR_DOC_ID, docId);
        params.put("state", status);
        params.put("errMessage", errMsg);
        params.put("createTime", DateUtils.getCurrentDateStr());
        int result = 0;
        try {
            result = icsIndexMapper.updateIndex(params);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]updateIndex DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]updateIndex error.", (Throwable)e);
        }
        return result;
    }

    public int updateProcessrate(IcsIndexMapper icsIndexMapper, String docId, String rate) {
        int result = 0;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, rate})) {
            return result;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(STR_DOC_ID, docId);
        params.put("processRate", rate);
        try {
            result = icsIndexMapper.updateProcessrate(params);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]updateProcessRate DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]updateProcessRate error.", (Throwable)e);
        }
        return result;
    }

    public List<IcsIndexDo> selectByDodIds(IcsIndexMapper icsIndexMapper, List<String> docIds) {
        ArrayList<IcsIndexDo> result = new ArrayList();
        try {
            result = icsIndexMapper.selectByDodIds(docIds);
        }
        catch (DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectByDodIds DataIntegrityViolationException.", (Throwable)e);
        }
        catch (MyBatisSystemException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]selectByDodIds error.", (Throwable)e);
        }
        return result;
    }

    public int updateIndexDir(IcsIndexMapper icsIndexMapper, String docId, String softVer, List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        int updateNums = 0;
        for (String refDocId : docIds) {
            params.put(STR_DOC_ID, docId);
            params.put(STR_REF_DOC_ID, refDocId);
            params.put("indexDir", this.getNewIndexDir(docId, refDocId, softVer));
            updateNums += icsIndexMapper.updateIndexDir(params);
        }
        return updateNums;
    }

    private String getNewIndexDir(String docId, String refDocId, String softVer) {
        return String.format(Locale.ENGLISH, IcsIndexConstants.HDX_INDEXDIR_FORMAT, docId, "_" + softVer, refDocId);
    }

    private static class IcsIndexDaoHandlerHolder {
        private static final IcsIndexDaoHandler INSTANCE = new IcsIndexDaoHandler();

        private IcsIndexDaoHandlerHolder() {
        }
    }
}

