/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.config.util;

import com.huawei.security.validator.validators.XSSValidator;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.dao.ConfigDao;
import java.io.File;
import java.text.Normalizer;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigUtil {
    private static final int MAX_LEGAL_KEY_LENGTH = 100;
    private static final int MAX_LEGAL_VALUE_LENGTH = 1000;
    private static XSSValidator xssValidator = new XSSValidator();

    public static boolean storeIcsLiteConfig() {
        Properties props = ConfigDao.getInstance().getConfig();
        String configFilePath = ConfigUtil.getConfigFilePath();
        File file = FileUtils.getFile((String[])new String[]{configFilePath});
        return PropertiesUtils.storeProperties((Properties)props, (String)file.getPath());
    }

    public static String getConfigFilePath() {
        return IcsCommonServiceHandler.getInstance().getComponentFilePath("userdata", "icsLiteConfig.properties");
    }

    public static String getDefaultConfigFilePath() {
        return IcsCommonServiceHandler.getInstance().getComponentFilePath("conf", "icsLiteDefaultConfig.properties");
    }

    public static String getScenePropertiesFilePath() {
        return IcsCommonServiceHandler.getInstance().getComponentFilePath("userdata", "liteScene.properties");
    }

    public static boolean isKeyLegal(String key) {
        if (StringUtils.isBlank((CharSequence)key) || key.length() >= 100) {
            return false;
        }
        String regalRegx = "[A-Za-z0-9.]*";
        return Normalizer.normalize(key, Normalizer.Form.NFC).matches(regalRegx);
    }

    public static boolean isValueLegal(String value) {
        if (StringUtils.isBlank((CharSequence)value) || value.length() >= 1000) {
            return false;
        }
        return xssValidator.inputValidate((Object)Normalizer.normalize(value, Normalizer.Form.NFC), null, null, null).isValidateResule();
    }
}

