<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" session="false" %>
<html style="width: 100%; height: 100%;">
<head>
    <title>download_page</title>
</head>
<style type="text/css">
    .page-download {
        width: 100%;
        height: 260px;
        overflow: hidden;
        position: relative;
        top: 50%;
        transform: translateY(-50%);
    }

    .page-download-image {
        width: 245px;
        height: 110px;
        margin: 0px auto;
        background: url(../resources/images/topic/iconDownload.png) no-repeat;
    }

    .page-download-text {
        float: left;
        width: 100%;
        line-height: 36px;
        font-size: 24px;
        font-family: '微软雅黑';
        color: #666;
        text-align: center;
        margin-bottom: 15px;
    }

    .page-download-link {
        float: left;
        width: 100%;
        height: 30px;
        display: -ms-inline-flexbox;
    }

    .download {
        display: block;
        width: 100%;
        max-width: 180px;
        height: 36px;
        line-height: 36px;
        font-size: 14px;
        font-family: '微软雅黑';
        color: #fff;
        background: #d85050;
        text-align: center;
        cursor: pointer;
        margin: 0 auto;
        text-decoration: none;
    }

    .download:hover {
        background-color: #ec3f40;
    }

    .page-download-link .download:visited {
        color: #fff;
    }

    .page-download-link .download {
        color: #fff;
    }
</style>
<body style="width: 100%; height: 100%;margin: 0;">
<div class="page-download">
    <div class="page-download-image"></div>
    <div class="page-download-text"></div>
    <div class="page-download-link"><a class="download" onclick="fileDownload()" style="border-radius:4px;"></a>
    </div>
</div>
</body>
<script type="text/javascript" src="../resources/lib/js/jquery.min.js"></script>
<script type="text/javascript" src="../resources/js/icsCommonUtil.js"></script>
</html>
<script>
    $('.download').text(parent.window.downloadFile);
    $('.page-download-text').eq(0).text(parent.window.noBrowse);
    var isIcs = parent.window.productflag;
    var docId = parent.window.docid || parent.window.docId;
    var hdxUrl = parent.window.hdxtopicurlthree;
    var icsUrl = parent.window.topicdownurl;

    function fileDownload() {
        let currentTopicDocId;
        let topicUrl;
        let nodeUrl;
        if (isIcs) {
            currentTopicDocId = parent.window.treeObj.getSelectedNodes()[0].docId;
            topicUrl = parent.window.treeObj.getSelectedNodes()[0].topicUrl;
            nodeUrl = parent.window.contextPath + String.format(icsUrl, currentTopicDocId, topicUrl);
        } else {
            topicUrl = parent.window.hdxTreeObj.getSelectedNodes()[0].topicUrl;
            currentTopicDocId = parent.window.hdxTreeObj.getSelectedNodes()[0].topicDocId;
            nodeUrl = parent.window.contextPath + "/" + String.format(hdxUrl, docId, currentTopicDocId, topicUrl);
        }
        try {
            var a = document.createElement('a');
            a.setAttribute('href', nodeUrl + "?status=1");
            a.setAttribute('id', 'js_a');
            //防止反复添加
            if (document.getElementById('js_a')) {
                document.body.removeChild(document.getElementById('js_a'));
            }
            document.body.appendChild(a);
            a.click();
        } catch (e) {

        }
    }
</script>
