#!/system/bin/sh

CRASHINFO_URL="http://crashinfo.tvip.tv/"
CRASHINFO_FILE="/storage/external_storage/crash.txt"

echo "Saving crash info to ${CRASHINFO_FILE}"
echo "" > ${CRASHINFO_FILE} # Create file
echo "=======================================================================" >> ${CRASHINFO_FILE}
echo "Device: "`getprop ro.product.device` >> ${CRASHINFO_FILE}
echo "Version: "`cat /etc/tvip_firmware.version`  >> ${CRASHINFO_FILE}
if [ -f /data/data/tv.tvip.app/files/update_type ]; then
echo "Update type: "`cat /data/data/tv.tvip.app/files/update_type`  >> ${CRASHINFO_FILE}
fi
echo "=======================================================================" >> ${CRASHINFO_FILE}
/system/xbin/ifconfig -a >> ${CRASHINFO_FILE}
echo "=======================================================================" >> ${CRASHINFO_FILE}

/system/bin/logcat  -t 3000 *:D  >> ${CRASHINFO_FILE}

CRASHINFO_FILESIZE=`ls -l ${CRASHINFO_FILE}| awk '{print $5}'`

echo "Sending crash info to ${CRASHINFO_URL} (${CRASHINFO_FILESIZE} bytes)"
sh -c "curl  -X POST --data-binary @${CRASHINFO_FILE} ${CRASHINFO_URL}" > /dev/null && echo Successfully sent && rm -f ${CRASHINFO_FILE} &

