#!/bin/sh

#Patch recovery and uboot if files exist

RECOVERY_IMG="/var/recovery.img"
RECOVERY_MD5="/var/recovery.md5"
BOOTLOADER_IMG="/var/bootloader.img"
BOOTLOADER_MD5="/var/bootloader.md5"

if [ -f $RECOVERY_IMG ]; then
  echo "Patching recovery"
  if [ -f $RECOVERY_MD5 ]; then
    write_raw_mtd recovery $RECOVERY_IMG $RECOVERY_MD5
  else
    write_raw_mtd recovery $RECOVERY_IMG
  fi
fi


if [ -f $BOOTLOADER_IMG ]; then
  echo "Patching bootloader"
  if [ -f $BOOTLOADER_MD5 ]; then
    write_raw_mtd bootloader $BOOTLOADER_IMG $BOOTLOADER_MD5
  else
    write_raw_mtd bootloader $BOOTLOADER_IMG
  fi
fi
