#! /bin/sh

do_init() {
    #
    # Bring up eth0 interface.
    # Kernel need some time to really bring interface up
    #
    ifconfig eth0 up

    echo "Mount /proc/bus/usb"
    mount -t usbfs none /proc/bus/usb
    
    
    echo "Mount /var/tvip"
    VAR_TVIP_DEV="/dev/misc"
    mount -t ext4 ${VAR_TVIP_DEV} /var/tvip
    if [ $? -ne 0 ]; then
      # Need to create filesystem
      rmdir /var/tvip
      echo "Creating EXT4 filesystem at ${VAR_TVIP_DEV} (background)"
      mkfs.ext4 -q ${VAR_TVIP_DEV} && mkdir -p /var/tvip && mount -t ext4 ${VAR_TVIP_DEV} /var/tvip #& - removed background start issue #1538
    fi

    #Allow all users access configs
    chmod 777 /var/tvip
    
    ## Data for timeshifting

    DATA_DEV="/dev/data"
    INTERNAL_MEDIA_DIR="/tmp/internal_media"
    
    echo "Mount ${INTERNAL_MEDIA_DIR}"

    # Try to mount
    mkdir -p ${INTERNAL_MEDIA_DIR}
    mount -t ext4 ${DATA_DEV} ${INTERNAL_MEDIA_DIR}
    if [ $? -ne 0 ]; then
      # Need to create filesystem
      rmdir ${INTERNAL_MEDIA_DIR}
      echo "Creating EXT4 filesystem at ${DATA_DEV} (background)"
      mkfs.ext4 -q ${DATA_DEV} && mkdir -p ${INTERNAL_MEDIA_DIR} && mount -t ext4 ${DATA_DEV} ${INTERNAL_MEDIA_DIR} &
    fi
    
    #Check for android content - we should format if it is found
    if [ -d "${INTERNAL_MEDIA_DIR}/app" ]; then
      umount ${INTERNAL_MEDIA_DIR}
      echo "Android content found. Clear internal media"
      mkfs.ext4 -q ${DATA_DEV} && mkdir -p ${INTERNAL_MEDIA_DIR} && mount -t ext4 ${DATA_DEV} ${INTERNAL_MEDIA_DIR} &
    fi
    
    # from xios
    # we startup as performance, then switch to ondemand (kernel bug) and
    # if m1 or m3, limit to 600Mhz to keep audio hw from stalling.
    #echo "Switching to ondemand"
    #echo "ondemand" > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
    #echo "600000"   > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq    
    
    #optimize memory usage (disable fake swapping)
    echo 0 > /proc/sys/vm/mem_management_thresh

    #Use agressive swap over zram
    echo 500M > /sys/block/zram0/disksize
    sysctl -w vm.swappiness=100
    mkswap /dev/zram0
    swapon /dev/zram0
    echo 4096 > /proc/sys/vm/mem_management_thresh
    
    # from xios /etc/init.s/S40network
    # bump up the default udp/tcp buffersizes
    echo "Bump up tcp/udp buffer sizes" 
    sysctl -w net.core.rmem_max=33554432
    sysctl -w net.core.netdev_max_backlog=2000
    sysctl -w net.ipv4.udp_mem='262144 327680 393216'
    sysctl -w net.ipv4.tcp_mem='262144 327680 393216'    
}



case "$1" in
  start)
      do_init
      ;;
  stop)
      ;;
  restart|reload)
      "$0" stop
      "$0" start
      ;;
  *)
      echo "Usage: $0 {start|stop|restart}"
      exit 1
esac

exit $?
