#!/bin/sh

do_tuning() {
    echo "Performing network tuning"
    #set igmp_version
    echo 2 > /proc/sys/net/ipv4/conf/all/force_igmp_version
    echo 2 > /proc/sys/net/ipv4/conf/default/force_igmp_version

    echo "Performing memory tuning"

    #from 7401 -alexey
    #echo 204800 > /proc/sys/net/core/rmem_max
    sysctl -w net.ipv4.udp_mem='524288 655360 786432'
    
    # Enable allocation all free memory for process
    echo 0 > /proc/sys/vm/overcommit_memory
    
    #Block igmpv1 if flag file exists
    if [ -f "/var/tvip/igmpv1_block" ]; then
      sysctl -w net.ipv4.conf.all.igmpv1_block=1
    fi

}


case "$1" in
  start)
      do_tuning
      ;;
  stop)
      ;;
  restart|reload)
      "$0" stop
      "$0" start
      ;;
  *)
      echo "Usage: $0 {start|stop|restart}"
      exit 1
esac

exit $?