#!/bin/sh

do_init() {

  # Setting-up timezone if it is not set yet. TODO: setup timezone from DHCP
  if [ ! -f /var/tvip/TZ ]; then
    echo "Creating default timezone"
    if [ -d /usr/share/zoneinfo/ ]; then
      echo "Europe/Moscow" > /var/tvip/TZ
    else
      echo "MSK-3" > /var/tvip/TZ
    fi
  else
    TIME_ZONE_CURR=`cat /var/tvip/TZ`
    if [ "$TIME_ZONE_CURR" == "MSK-4" ]; then
      echo "MSK-3" > /var/tvip/TZ
    fi
  fi


  # Clear all /var/tvip if it not be cleared before (/var/tvip/.init_done does not exists)
  if [ ! -f /var/tvip/.init_done ]; then
      echo "=== Deleting config files in /var/tvip"
      STORE_FILES="device_authkey account_id display_mode udpxy update_type"
      for STORE_FILE in ${STORE_FILES}; do
      echo "==== Store file: ${STORE_FILE}"
      if [ -f /var/tvip/${STORE_FILE} ]; then
          cp /var/tvip/${STORE_FILE} /tmp/
      fi
      done

      rm -R /var/tvip/*

      for STORE_FILE in ${STORE_FILES}; do
      echo "==== Restore file: ${STORE_FILE}"
      if [ -f /tmp/${STORE_FILE} ]; then
          cp /tmp/${STORE_FILE} /var/tvip/
      fi
      done

      echo > /var/tvip/.init_done
  fi

  # remove old firmware information file
  rm -f /var/tvip/tvip_firmware.info
}




case "$1" in
  start)
      do_init
      ;;
  stop)
      ;;
  restart|reload)
      "$0" stop
      "$0" start
      ;;
  *)
      echo "Usage: $0 {start|stop|restart}"
      exit 1
esac

exit $?
