#!/bin/sh

BLUETOOTHD=/usr/bin/bluetoothd
ETH_ADDRESS=/sys/class/net/eth0/address
BT_STATE=/sys/class/rfkill/rfkill0/state
BT_TTY=/dev/ttyS2
PATCHRAM_WRAPPER=/tmp/bt_patchram_wrapper

if [ ! -x ${PATCHRAM_WRAPPER} ]; then
  echo "Patchram wrapper not found"
  exit 1
fi

if [ ! -x ${BLUETOOTHD} ]; then
  echo "Bluetooth daemon not found"
  exit 1
fi

if [ ! -e ${ETH_ADDRESS} ]; then
  echo "No ethernet device"
  exit 1
fi

if [ ! -e ${BT_STATE} ]; then
  echo "No bluetooth device"
  exit 1
fi

if [ ! -e ${BT_TTY} ]; then
  echo "No bluetooth tty"
  exit 1
fi

case "$1" in
  start)
    echo "Starting bluetooth..."
    echo 0 > ${BT_STATE}
    echo 1 > ${BT_STATE}
    $PATCHRAM_WRAPPER $1 $BT_TTY $ETH_ADDRESS
    sh -c "while [ \"1\" ]; do /usr/bin/bluetoothd; done" &
    TVIP_LOG_SYSLOG=y TVIP_LOG_LEVEL=debug sh -c "while [ \"1\" ]; do /usr/sbin/tvipbluetoothd; done" &
  ;;
  stop)
    echo "Stopping bluetooth..."
    kill -9 `ps $PS_OPTION | grep  "bluetooth" | grep -v grep | awk '{ print $1 }'`
    $PATCHRAM_WRAPPER $1
  ;;
  restart|reload)
    "$0"  stop
    sleep 1
    "$0" start
  ;;
  *)
  ;;
esac

exit 0
