#!/bin/sh

AUTH=0

start() {
      printf "Starting adbd:\n"
      if [ ! -e /var/tvip/adbd_enable ]
        then
          printf "Adbd disabled\n"
          return
      fi

      if [ -e /var/tvip/adbd_enable_auth ]
        then
          printf "Adbd auth check enabled\n"
          AUTH=1
      fi

      start-stop-daemon -S -q -m -b -p /var/run/adbd.pid \
			-x /usr/bin/env ADBD_ENABLE_AUTH=$AUTH /usr/bin/adbd
      [ $? = 0 ] && echo "OK" || echo "FAILED"
}

stop() {
	printf "Stopping adbd:\n"
	start-stop-daemon -K -q -p /var/run/adbd.pid \
			  -x /usr/bin/adbd
	[ $? = 0 ] && echo "OK" || echo "FAILED"
}

case "$1" in
    start)
	start
	;;
    stop)
	stop
	;;
    restart|reload)
	stop
	start
	;;
  *)
	echo "Usage: $0 {start|stop|restart}"
	exit 1
esac

exit $?
