#!/bin/sh -e
#
# Original version by Robert Leslie
# <rob@mars.org>, edited by iwj and cs
# Modified for openvpn by Alberto Gonzalez Iniesta <agi@agi.as>
# Modified for restarting / starting / stopping single tunnels by Richard Mueller <mueller@teamix.net>

test $DEBIAN_SCRIPT_DEBUG && set -v -x

DAEMON=/usr/bin/openvpn
CONFIG_DIR=/var/tvip/openvpn
test -x $DAEMON || exit 0
test -d $CONFIG_DIR || exit 0

start_vpn () {
    $DAEMON --daemon --writepid /var/run/openvpn.$NAME.pid \
            --config $CONFIG_DIR/$NAME.conf --cd $CONFIG_DIR || printf " FAILED->"
    printf " $NAME"
}
stop_vpn () {
   kill `cat $PIDFILE` || true
  rm $PIDFILE
}

case "$1" in
start)
  printf "Starting openvpn:"

  if test -z $2 ; then
    for CONFIG in `cd $CONFIG_DIR; ls *.conf 2> /dev/null`; do
      NAME=${CONFIG%%.conf}
      start_vpn
    done
  else
    if test -e $CONFIG_DIR/$2.conf ; then
      NAME=$2
      start_vpn
    else
      printf " No such VPN: $2"
    fi
  fi
  echo "."

  ;;
stop)
  printf "Stopping openvpn:"

  if test -z $2 ; then
    for PIDFILE in `ls /var/run/openvpn.*.pid 2> /dev/null`; do
      NAME=`echo $PIDFILE | cut -c18-`
      NAME=${NAME%%.pid}
      stop_vpn
      printf " $NAME"
    done
  else
    if test -e /var/run/openvpn.$2.pid ; then
      PIDFILE=`ls /var/run/openvpn.$2.pid 2> /dev/null`
      NAME=`echo $PIDFILE | cut -c18-`
      NAME=${NAME%%.pid}
      stop_vpn
      printf " $NAME"
    else
      printf " No such VPN: $2"
    fi
  fi
  echo "."
  ;;
# We only 'reload' for running VPNs. New ones will only start with 'start' or 'restart'.
reload|force-reload)
  printf "Reloading openvpn:"
  for PIDFILE in `ls /var/run/openvpn.*.pid 2> /dev/null`; do
    NAME=`echo $PIDFILE | cut -c18-`
    NAME=${NAME%%.pid}
# If openvpn if running under a different user than root we'll need to restart
    if egrep '^( |\t)*user' $CONFIG_DIR/$NAME.conf > /dev/null 2>&1 ; then
      stop_vpn
      sleep 1
      start_vpn
      printf "(restarted)"
    else
      kill -HUP `cat $PIDFILE` || true
#    start-stop-daemon --stop --signal HUP --quiet --oknodo \
#      --exec $DAEMON --pidfile $PIDFILE
    printf " $NAME"
    fi
  done
  echo "."
  ;;

restart)
  $0 stop $2
  sleep 1
  $0 start $2
  ;;
*)
  echo "Usage: $0 {start|stop|reload|restart|force-reload}" >&2
  exit 1
  ;;
esac

exit 0

# vim:set ai et sts=2 sw=2 tw=0:
