#!/bin/sh

#Amlogic find recovery
RECOVERY_DEV=/dev/cache

if [ -e ${RECOVERY_DEV} ]; then
  echo "Mounting recovery cache..."
  mkdir /tmp/recovery
  mount -t ext4 -o noexec ${RECOVERY_DEV} /tmp/recovery
  if [ $? -ne 0 ]; then
      # Need to create filesystem
      rmdir /tmp/recovery
      echo "Creating EXT4 filesystem at ${RECOVERY_DEV} (background)"
      mkfs.ext4 -q ${RECOVERY_DEV} && mkdir -p /tmp/recovery && mount -t ext4 -o noexec ${RECOVERY_DEV} /tmp/recovery
  fi
  
  
  mkdir /tmp/recovery/recovery 2> /dev/null
fi
