#/bin/sh

log() {
  echo "S90upgrade: $@"
}

try_usb_upgrade() {

  DEVICE_ID=`cat /etc/tvip_deviceid`

  #BEGIN TRY TO MOUNT USB
  if [ -r /proc/bus/usb/devices ];
  then
    cat /proc/bus/usb/devices | grep "usb-storage"
    if [ $? -eq 0 ] ; then
      #We have USB storage installed
      log "usb storage device is installed"
      NEED_MOUNT="1"
    fi
  else
    #Try to find sd* devices
    ls -1 /sys/block/ | grep -E "^sd"
    if [ $? -eq 0 ] ; then 
      #We have USB storage installed
      log "usb storage device is installed"
      NEED_MOUNT="1"
    fi
  fi

  cat /proc/partitions | grep -E "mmcblk0boot0"
  if [ $? -eq 0 ] ; then
    cat /proc/partitions | grep -E "mmcblk1p1"
    if [ $? -eq 0 ] ; then
        #We have USB storage installed
        log "SD card is installed"
        NEED_MOUNT="1"
				EMMC_BOOT="1"
    fi
  else
    cat /proc/partitions | grep -E "mmcblk0p1|cardblk"
    if [ $? -eq 0 ] ; then
        #We have USB storage installed
        log "SD card is installed"
        NEED_MOUNT="1"
    fi
  fi


  if [ ! -z "${NEED_MOUNT}" ]; then
      ATTEMPTS=0
      MOUNT_POINT=/tmp/mnt_recovery
      mkdir -p ${MOUNT_POINT}

      while [[ "${ATTEMPTS}" -lt 10 && -z "${PARTITIONS_FOUND}" ]]; do
          sleep 1

          log "trying to mount: ${ATTEMPTS}"

          #Try to mount
          if [ -z "${EMMC_BOOT}" ]; then
                  PARTITIONS=`cat /proc/partitions | grep -E "sd[a-z]|cardblksd|mmcblk0p1" | awk '{print $4}'`
          else
                  PARTITIONS=`cat /proc/partitions | grep -E "sd[a-z]|mmcblk1p1" | awk '{print $4}'`
          fi
          for PARTITION in ${PARTITIONS}; do
              
              PARTITIONS_FOUND=1
              PARTITIONS_MOUNTED=0
              log "Trying to mount /dev/${PARTITION} to ${MOUNT_POINT}" 
              mount -t vfat -o codepage=866,iocharset=utf8 /dev/${PARTITION}  ${MOUNT_POINT} > /dev/null 2>&1
              if [ $? -eq "0" ]; then
                  PARTITIONS_MOUNTED=1
              else
                  mount /dev/${PARTITION}  ${MOUNT_POINT} > /dev/null 2>&1
                  if [ $? -eq "0" ]; then
                      PARTITIONS_MOUNTED=1
                  fi
              fi   

              #if [ $? -eq "0" ]; then
              if [ "${PARTITIONS_MOUNTED}" -eq "1" ]; then
                  if [ -f ${MOUNT_POINT}/${DEVICE_ID}/start ]; then
                      /usr/bin/show_message "Found ${DEVICE_ID}/start on the removable drive.\nExecuting ${DEVICE_ID}/start..."
                      
                      log "Found ${DEVICE_ID}/start, Executing"
                      
                      if [ -x ${MOUNT_POINT}/${DEVICE_ID}/start ]; then
                        ${MOUNT_POINT}/${DEVICE_ID}/start
                      else
                        /bin/sh ${MOUNT_POINT}/${DEVICE_ID}/start
                      fi
                  elif [[ -f ${MOUNT_POINT}/tvip_firmware.bin && -x /usr/bin/gupdater ]]; then
                    /usr/bin/gupdater -r ${MOUNT_POINT}/tvip_firmware.bin
                  else
                    log "No update script (${DEVICE_ID}/start) found on the device /dev/${PARTITION}. Ignoring"
                  fi
                  
                  # do not exit after this.
                  umount ${MOUNT_POINT}
              fi
          done
          (( ATTEMPTS++ ))

      done
  fi
  #END TRY TO MOUNT USB

}


case "$1" in
  start)
      try_usb_upgrade
      ;;
  stop)
      ;;
  restart|reload)
      "$0" stop
      "$0" start
      ;;
  *)
      echo "Usage: $0 {start|stop|restart}"
      exit 1
esac

exit $?

