#! /bin/sh

I=${0##*/} # get $0 and return last '/'-delimited element. Example: '/etc/init.d/S93easycwmpd.sh' --> 'S93easycwmpd.sh'
UBUS_UNIX_SOCKET=/tmp/ubus.sock
DEFAULT_CONFIG_DIR=/etc/easycwmp_default
DEFAULT_CONFIG_PATH=$DEFAULT_CONFIG_DIR/easycwmp
VARTVIP_DIR=/var/tvip
CONFIG_DIR=$VARTVIP_DIR/easycwmp
CONFIG_PATH=$CONFIG_DIR/easycwmp
USER_SERVER_CONFIG_PATH=$VARTVIP_DIR/tr69_server
USER_PROV_SERVER_CONFIG_PATH=$VARTVIP_DIR/tr69_server.prov
FIRMWARE_SERVER_CONFIG_PATH=/etc/tr69_server
EASYCWMP_SCRIPTS=/usr/sbin/easycwmp_scripts

UCI_GET="/usr/bin/uci -q -c $CONFIG_DIR get"
UCI_GET_DEFAULT="/usr/bin/uci -q -c $DEFAULT_CONFIG_DIR get"
UCI_SET="/usr/bin/uci -q -c $CONFIG_DIR set"
UCI_COMMIT="/usr/bin/uci -q -c $CONFIG_DIR commit"

source $EASYCWMP_SCRIPTS/check_stun.sh

uciSet() {
  local OPTION="$1"
  local VALUE="$2"
  $UCI_SET $OPTION=$VALUE
  $UCI_COMMIT
}

takeDefaultConfig() {
  mkdir -p $CONFIG_DIR
  cp $DEFAULT_CONFIG_PATH $CONFIG_PATH
  local default_iface=$(</tmp/iface_for_tr69sh)
  uciSet easycwmp.@local[0].interface $default_iface
}

startTr69() {
  local SERVER_CONFIG_PATH="$1"

  echo "$I: $SERVER_CONFIG_PATH exists. Starting tr69..."
  if [ -f $CONFIG_PATH ]; then
    DEFAULT_VERSION=`$UCI_GET_DEFAULT easycwmp.@this_config[0].version`
    CONFIG_VERSION=`$UCI_GET easycwmp.@this_config[0].version`
    if [[ "$DEFAULT_VERSION" != "$CONFIG_VERSION" ]]; then
      echo "$I: $CONFIG_PATH has different version ($CONFIG_VERSION) than version ($DEFAULT_VERSION) of $DEFAULT_CONFIG_PATH. Copying $DEFAULT_CONFIG_PATH --> $CONFIG_PATH"
      takeDefaultConfig
    else
      echo "$I: Config $CONFIG_PATH of same version ($CONFIG_VERSION) as the $DEFAULT_CONFIG_PATH. Skip copying"
    fi
  else
    echo "$I: $CONFIG_PATH doesn't exist. Copying $DEFAULT_CONFIG_PATH --> $CONFIG_PATH"
    takeDefaultConfig
  fi

  NEW_URL=`sed '1!d' $SERVER_CONFIG_PATH` # get first line of config
  NEW_USERNAME=`sed '2!d' $SERVER_CONFIG_PATH`
  NEW_PASSWORD=`sed '3!d' $SERVER_CONFIG_PATH`

  URL=`$UCI_GET easycwmp.@acs[0].url`
  USERNAME=`$UCI_GET easycwmp.@acs[0].username`
  PASSWORD=`$UCI_GET easycwmp.@acs[0].password`

  if [[ "$NEW_URL" != "$URL" || "$NEW_USERNAME" != "$USERNAME" || "$NEW_PASSWORD" != "$PASSWORD" ]]; then
    echo "$I: New ACS settings available in $SERVER_CONFIG_PATH. Setting them to $CONFIG_PATH..."
    uciSet "easycwmp.@acs[0].url" $NEW_URL
    uciSet "easycwmp.@acs[0].username" $NEW_USERNAME
    uciSet "easycwmp.@acs[0].password" $NEW_PASSWORD
  else
    echo "$I: ACS settings in $SERVER_CONFIG_PATH are the same as in $CONFIG_PATH"
  fi

  echo "$I: Starting easycwmpd..."

  UBUS_PROCESS=`ps aux | grep -v grep | grep /usr/bin/ubusd`
  EASYCWMPD_PROCESS=`ps aux | grep -v grep | grep /usr/sbin/easycwmpd`
  TVIPCWPD_PROCESS=`ps aux | grep -v grep | grep /usr/sbin/tvipcwmpd`

  if [[ "${#UBUS_PROCESS}" -gt "0" || "${EASYCWMPD_PROCESS}" -gt "0" || ${TVIPCWPD_PROCESS} -gt "0" ]]; then
    echo -e "$I: easycwmpd is already running. Dump:\n==> $UBUS_PROCESS\n==> $EASYCWMPD_PROCESS"
  else
    /usr/bin/ubusd -s $UBUS_UNIX_SOCKET &
    /usr/sbin/tvipcwmpd &
    /usr/sbin/easycwmpd -b &

    local stun_enable=`$UCI_GET easycwmp.@stun[0].enable`
    check_stun $stun_enable
  fi

  return 0
}

case "$1" in
  start)
    if [ -f $USER_SERVER_CONFIG_PATH ]; then #/var/tvip/tr69_server
      startTr69 $USER_SERVER_CONFIG_PATH
    else
      if [ -f $USER_PROV_SERVER_CONFIG_PATH ]; then #/etc/tr69_server.prov
        startTr69 $USER_PROV_SERVER_CONFIG_PATH
      else
        if [ -f $FIRMWARE_SERVER_CONFIG_PATH ]; then #/etc/tr69_server
          startTr69 $FIRMWARE_SERVER_CONFIG_PATH
        else
          echo "$I: Skip starting tr69: neither config $USER_SERVER_CONFIG_PATH nor the config $USER_PROV_SERVER_CONFIG_PATH nor the $FIRMWARE_SERVER_CONFIG_PATH doesn't exist"
        fi
      fi
    fi
    ;;
  stop)
    echo "$I: Stopping easycwmpd..."
    killall easycwmpd
    killall tvipcwmpd
    killall ubusd
    kill_stun
    ;;
  restart|reload)
    "$0" stop
    "$0" start
    ;;
  *)
    ;;
esac

exit $?


